/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.management.BaseNativeInterfaceAddStepHandler;
import org.jboss.as.controller.management.NativeInterfaceCommonPolicy;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends BaseNativeInterfaceAddStepHandler {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    public NativeManagementAddHandler() {
        super(NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY;
    }

    protected void installServices(OperationContext context, NativeInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName endpointName = ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        NativeManagementServices.installManagementWorkerService(serviceTarget, context.getServiceRegistry(false));
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostName, context.getServiceRegistry(false));
        String bindingName = NativeManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        ServiceName socketBindingServiceName = context.getCapabilityServiceName("org.wildfly.network.socket-binding", bindingName, SocketBinding.class);
        String securityRealm = commonPolicy.getSecurityRealm();
        if (securityRealm == null) {
            ServerLogger.ROOT_LOGGER.nativeManagementInterfaceIsUnsecured();
        }
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.server.temp.dir"});
        RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"management", (String)securityRealm, null, (ServiceName)tmpDirPath);
        ManagementRemotingServices.installConnectorServicesForSocketBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)socketBindingServiceName, (OptionMap)commonPolicy.getConnectorOptions());
    }
}

