/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import io.undertow.server.ListenerRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.management.BaseHttpInterfaceAddStepHandler;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.network.SocketBindingManagerImpl;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ExternalManagementRequestExecutor;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class HttpManagementAddHandler
extends BaseHttpInterfaceAddStepHandler {
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();

    public HttpManagementAddHandler() {
        super(HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && (context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY);
    }

    protected List<ServiceName> installServices(OperationContext context, HttpInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        String securityRealm;
        ModelNode secureSocketBindingNode;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName socketBindingServiceName = null;
        ServiceName secureSocketBindingServiceName = null;
        ModelNode socketBindingNode = HttpManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model);
        if (socketBindingNode.isDefined()) {
            String bindingName = socketBindingNode.asString();
            socketBindingServiceName = context.getCapabilityServiceName("org.wildfly.network.socket-binding", bindingName, SocketBinding.class);
        }
        if ((secureSocketBindingNode = HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.resolveModelAttribute(context, model)).isDefined()) {
            String bindingName = secureSocketBindingNode.asString();
            secureSocketBindingServiceName = context.getCapabilityServiceName("org.wildfly.network.socket-binding", bindingName, SocketBinding.class);
        }
        if (socketBindingServiceName != null) {
            if (secureSocketBindingServiceName != null) {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocketAndSecureSocket(socketBindingServiceName.getSimpleName(), secureSocketBindingServiceName.getSimpleName());
            } else {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocket(socketBindingServiceName.getSimpleName());
            }
        } else if (secureSocketBindingServiceName != null) {
            ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSecureSocket(secureSocketBindingServiceName.getSimpleName());
        }
        ConsoleMode consoleMode = this.consoleMode(commonPolicy.isConsoleEnabled(), context.getRunningMode() == RunningMode.ADMIN_ONLY);
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService(requestProcessorName, serviceTarget);
        NativeManagementServices.installManagementWorkerService(serviceTarget, context.getServiceRegistry(false));
        ServerEnvironment environment = (ServerEnvironment)context.getServiceRegistry(false).getRequiredService(ServerEnvironmentService.SERVICE_NAME).getValue();
        UndertowHttpManagementService undertowService = new UndertowHttpManagementService(consoleMode, environment.getProductConfig().getConsoleSlot());
        ServiceBuilder undertowBuilder = serviceTarget.addService(UndertowHttpManagementService.SERVICE_NAME, (Service)undertowService).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, undertowService.getModelControllerInjector()).addDependency(SocketBindingManagerImpl.SOCKET_BINDING_MANAGER, SocketBindingManager.class, undertowService.getSocketBindingManagerInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, undertowService.getControlledProcessStateServiceInjector()).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, undertowService.getListenerRegistry()).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, undertowService.getRequestProcessorValue()).addDependency(ManagementWorkerService.SERVICE_NAME, XnioWorker.class, undertowService.getWorker()).addDependency(ExternalManagementRequestExecutor.SERVICE_NAME, Executor.class, undertowService.getManagementExecutor()).addInjection(undertowService.getAllowedOriginsInjector(), (Object)commonPolicy.getAllowedOrigins());
        if (socketBindingServiceName != null) {
            undertowBuilder.addDependency(socketBindingServiceName, SocketBinding.class, undertowService.getSocketBindingInjector());
        }
        if (secureSocketBindingServiceName != null) {
            undertowBuilder.addDependency(secureSocketBindingServiceName, SocketBinding.class, undertowService.getSecureSocketBindingInjector());
        }
        if ((securityRealm = commonPolicy.getSecurityRealm()) != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)undertowBuilder, undertowService.getSecurityRealmInjector(), (String)securityRealm, (boolean)false);
        } else {
            ServerLogger.ROOT_LOGGER.httpManagementInterfaceIsUnsecured();
        }
        undertowBuilder.install();
        HttpShutdownService shutdownService = new HttpShutdownService();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        serviceTarget.addService(shutdownName, (Service)shutdownService).addDependency(requestProcessorName, ManagementHttpRequestProcessor.class, shutdownService.getProcessorValue()).addDependency(Services.JBOSS_SERVER_EXECUTOR, Executor.class, shutdownService.getExecutorValue()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, shutdownService.getMgmtChannelRegistry()).addDependency(UndertowHttpManagementService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (commonPolicy.isHttpUpgradeEnabled()) {
            String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
            ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.server.temp.dir"});
            RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"http-management", (String)securityRealm, null, (ServiceName)tmpDirPath);
            NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostName, context.getServiceRegistry(false));
            String httpConnectorName = socketBindingServiceName != null || secureSocketBindingServiceName == null ? "http-management" : "https-management";
            RemotingHttpUpgradeService.installServices((ServiceTarget)serviceTarget, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)commonPolicy.getConnectorOptions());
            return Arrays.asList(UndertowHttpManagementService.SERVICE_NAME, RemotingHttpUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}));
        }
        return Collections.singletonList(UndertowHttpManagementService.SERVICE_NAME);
    }

    private ConsoleMode consoleMode(boolean consoleEnabled, boolean adminOnly) {
        return consoleEnabled ? (adminOnly ? ConsoleMode.ADMIN_ONLY : ConsoleMode.CONSOLE) : ConsoleMode.NO_CONSOLE;
    }
}

