/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

public class RuntimeVaultReader
extends AbstractVaultReader {
    private volatile SecurityVault vault;
    private final AtomicBoolean missingVaultLogged = new AtomicBoolean();

    @Override
    protected void createVault(String fqn, Map<String, Object> options) throws VaultReaderException {
        this.createVault(fqn, null, options);
    }

    @Override
    protected void createVault(final String fqn, final String module, Map<String, Object> options) throws VaultReaderException {
        HashMap<String, Object> vaultOptions = new HashMap<String, Object>(options);
        SecurityVault vault = null;
        try {
            vault = AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityVault>(){

                @Override
                public SecurityVault run() throws Exception {
                    if (fqn == null || fqn.isEmpty()) {
                        return SecurityVaultFactory.get();
                    }
                    if (module == null) {
                        return SecurityVaultFactory.get((String)fqn);
                    }
                    return SecurityVaultFactory.get((ClassLoader)RuntimeVaultReader.this.getModuleClassLoader(module), (String)fqn);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (!(t instanceof Error)) {
                throw ServerLogger.ROOT_LOGGER.cannotCreateVault(t, t);
            }
            throw (Error)t;
        }
        try {
            vault.init(vaultOptions);
        }
        catch (SecurityVaultException e) {
            throw ServerLogger.ROOT_LOGGER.cannotCreateVault(e, e);
        }
        this.vault = vault;
    }

    @Override
    protected void destroyVault() {
        this.vault = null;
        this.missingVaultLogged.set(false);
    }

    public String retrieveFromVault(String vaultedData) throws VaultReaderException {
        if (this.isVaultFormat(vaultedData)) {
            block6: {
                SecurityVault theVault = this.vault;
                if (theVault != null) {
                    try {
                        char[] val = RuntimeVaultReader.getValue(theVault, vaultedData);
                        if (val != null) {
                            return new String(val);
                        }
                        break block6;
                    }
                    catch (SecurityVaultException e) {
                        throw ServerLogger.ROOT_LOGGER.vaultReaderException((Exception)((Object)e));
                    }
                }
                if (this.missingVaultLogged.compareAndSet(false, true)) {
                    ServerLogger.ROOT_LOGGER.vaultNotInitializedException();
                }
            }
            throw new VaultReader.NoSuchItemException();
        }
        return vaultedData;
    }

    public boolean isVaultFormat(String str) {
        return str != null && STANDARD_VAULT_PATTERN.matcher(str).matches();
    }

    private static char[] getValue(SecurityVault vault, String vaultString) throws SecurityVaultException {
        String[] tokens = RuntimeVaultReader.tokens(vaultString);
        byte[] sharedKey = null;
        if (tokens.length > 3) {
            sharedKey = tokens[3].getBytes(StandardCharsets.UTF_8);
        }
        return vault.exists(tokens[1], tokens[2]) ? vault.retrieve(tokens[1], tokens[2], sharedKey) : null;
    }

    private static String[] tokens(String vaultString) {
        StringTokenizer tokenizer = new StringTokenizer(vaultString, "::");
        int length = tokenizer.countTokens();
        String[] tokens = new String[length];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }

    private ModuleClassLoader getModuleClassLoader(String moduleSpec) throws ModuleLoadException {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleSpec));
        return WildFlySecurityManager.isChecking() ? (ModuleClassLoader)AccessController.doPrivileged(new GetModuleClassLoaderAction(module)) : module.getClassLoader();
    }
}

