/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class ManagedExplodedContentServitor
implements Service<VirtualFile> {
    private final InjectedValue<ContentRepository> contentRepositoryInjectedValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentInjectedValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjectedValue = new InjectedValue();
    private final String managementName;
    private final byte[] hash;
    private volatile Path deploymentRoot;

    static ServiceController<?> addService(ServiceTarget serviceTarget, ServiceName serviceName, String managementName, byte[] hash) {
        ManagedExplodedContentServitor service = new ManagedExplodedContentServitor(managementName, hash);
        return Services.addServerExecutorDependency(serviceTarget.addService(serviceName, (Service)service), service.executorInjectedValue, false).addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.contentRepositoryInjectedValue).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironmentInjectedValue).install();
    }

    private ManagedExplodedContentServitor(String managementName, byte[] hash) {
        this.managementName = managementName;
        this.hash = hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        final Path root = DeploymentHandlerUtil.getExplodedDeploymentRoot((ServerEnvironment)this.serverEnvironmentInjectedValue.getValue(), this.managementName);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CountDownLatch latch = ManagedExplodedContentServitor.this.asyncCleanup(root);
                    if (latch != null) {
                        try {
                            if (!latch.await(60L, TimeUnit.SECONDS)) {
                                context.failed(new StartException());
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            context.failed(new StartException());
                            return;
                        }
                    }
                    Files.createDirectories(root.getParent(), new FileAttribute[0]);
                    ((ContentRepository)ManagedExplodedContentServitor.this.contentRepositoryInjectedValue.getValue()).copyExplodedContent(ManagedExplodedContentServitor.this.hash, root);
                    ManagedExplodedContentServitor.this.deploymentRoot = root;
                    context.complete();
                }
                catch (IOException | ExplodedContentException e) {
                    context.failed(new StartException(e));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjectedValue.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        final Path theRoot = this.deploymentRoot;
        this.deploymentRoot = null;
        if (theRoot != null) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            CountDownLatch latch = ManagedExplodedContentServitor.this.asyncCleanup(theRoot);
                            if (latch == null) break block7;
                            try {
                                if (latch.await(60L, TimeUnit.SECONDS)) {
                                    // empty if block
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            context.complete();
                        }
                    }
                }
            };
            try {
                ((ExecutorService)this.executorInjectedValue.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        }
    }

    public VirtualFile getValue() {
        if (this.deploymentRoot == null) {
            throw new IllegalStateException();
        }
        return VFS.getChild((String)this.deploymentRoot.toAbsolutePath().toString());
    }

    private CountDownLatch asyncCleanup(final Path root) throws IOException {
        CountDownLatch result;
        if (root.toFile().exists()) {
            result = new CountDownLatch(1);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ManagedExplodedContentServitor.recursiveDelete(root);
                    }
                    finally {
                        result.countDown();
                    }
                }
            };
            ((ExecutorService)this.executorInjectedValue.getValue()).submit(r);
        } else {
            result = null;
        }
        return result;
    }

    private static void recursiveDelete(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(path);){
                files.forEach(ManagedExplodedContentServitor::recursiveDelete);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

