/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.DeferredExtensionContext;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.AuditLogXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.ExtensionHandler;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class StandaloneXml_7
extends CommonXml
implements ManagementXmlDelegate {
    private final AccessControlXml accessControlXml;
    private final StandaloneXml.ParsingOption[] parsingOptions;
    private AuditLogXml auditLogDelegate;
    private final Namespace namespace;
    private ExtensionHandler extensionHandler;
    private final DeferredExtensionContext deferredExtensionContext;

    StandaloneXml_7(ExtensionHandler extensionHandler, Namespace namespace, DeferredExtensionContext deferredExtensionContext, StandaloneXml.ParsingOption ... options) {
        super(new SocketBindingsXml.ServerSocketBindingsXml());
        this.namespace = namespace;
        this.extensionHandler = extensionHandler;
        this.accessControlXml = AccessControlXml.newInstance((Namespace)namespace);
        this.auditLogDelegate = AuditLogXml.newInstance((Namespace)namespace, (boolean)false);
        this.deferredExtensionContext = deferredExtensionContext;
        this.parsingOptions = options;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        long start = System.currentTimeMillis();
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.SERVER) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        boolean validNamespace = false;
        for (Namespace current : Namespace.domainValues()) {
            if (!this.namespace.equals((Object)current)) continue;
            validNamespace = true;
            this.readServerElement(reader, address, operationList);
            break;
        }
        if (!validNamespace) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (ServerLogger.ROOT_LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            ServerLogger.ROOT_LOGGER.debugf("Parsed standalone configuration in [%d] ms", elapsed);
        }
    }

    private void readServerElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        ModelNode serverName = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = ServerRootResourceDefinition.NAME.parse(value, (XMLStreamReader)reader);
                            continue block12;
                        }
                        case ORGANIZATION: {
                            this.setOrganization(address, list, ServerRootResourceDefinition.ORGANIZATION_IDENTIFIER.parse(value, (XMLStreamReader)reader));
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block12;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionHandler.parseExtensions(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)this.namespace, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        this.deferredExtensionContext.load();
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, this.namespace, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, this.namespace, new ModelNode(), list, true, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHttpManagementInterfaceAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HTTP_AUTHENTICATION_FACTORY: {
                    HttpManagementResourceDefinition.HTTP_AUTHENTICATION_FACTORY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case SASL_PROTOCOL: {
                    HttpManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case SERVER_NAME: {
                    HttpManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case SSL_CONTEXT: {
                    HttpManagementResourceDefinition.SSL_CONTEXT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case CONSOLE_ENABLED: {
                    HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block9;
                }
                case ALLOWED_ORIGINS: {
                    for (String origin : reader.getListAttributeValue(i)) {
                        HttpManagementResourceDefinition.ALLOWED_ORIGINS.parseAndAddParameterElement(origin, addOp, (XMLStreamReader)reader);
                    }
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterfaceAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SASL_AUTHENTICATION_FACTORY: {
                    NativeManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SASL_PROTOCOL: {
                    NativeManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SERVER_NAME: {
                    NativeManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SSL_CONTEXT: {
                    NativeManagementResourceDefinition.SSL_CONTEXT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        this.parseNativeManagementInterfaceAttributes(reader, addOp);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedElement(reader.getName(), reader.getLocation(), "socket-binding");
                }
                case SOCKET_BINDING: {
                    this.parseNativeManagementSocketBinding(reader, addOp);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseHttpManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "http-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        this.parseHttpManagementInterfaceAttributes(reader, addOp);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    throw ControllerLogger.ROOT_LOGGER.unsupportedElement(reader.getName(), reader.getLocation(), "socket-binding");
                }
                case SOCKET_BINDING: {
                    this.parseHttpManagementSocketBinding(reader, addOp);
                    continue block5;
                }
                case HTTP_UPGRADE: {
                    this.parseHttpUpgrade(reader, addOp);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseHttpManagementSocketBinding(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HTTP: {
                    HttpManagementResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                case HTTPS: {
                    HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseHttpUpgrade(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.ENABLED.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block4;
                }
                case SASL_AUTHENTICATION_FACTORY: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseNativeManagementSocketBinding(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasRef = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NATIVE: {
                    NativeManagementResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasRef = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!hasRef) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REF.getLocalName()));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseNativeRemotingManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-remoting-interface");
        connector.get("address").set(operationAddress);
        list.add(connector);
        reader.discardRemainder();
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    if (op.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() == ModelType.EXPRESSION || interfaces.contains(value)) continue block9;
                    throw ControllerLogger.ROOT_LOGGER.unknownInterface(value, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block10: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap profileOps = new LinkedHashMap();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String namespace = reader.getNamespaceURI();
            if (profileOps.containsKey(namespace)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            try {
                reader.handleAny(subsystems);
            }
            catch (XMLStreamException e) {
                if (StandaloneXml.ParsingOption.IGNORE_SUBSYSTEM_FAILURES.isSet(this.parsingOptions)) {
                    QName element = new QName(reader.getNamespaceURI(), reader.getLocalName());
                    ControllerLogger.ROOT_LOGGER.failedToParseElementLenient(e, element.toString());
                    reader.discardRemainder();
                }
                throw e;
            }
            profileOps.put(namespace, subsystems);
        }
        Set<ProfileParsingCompletionHandler> completionHandlers = this.extensionHandler.getProfileParsingCompletionHandlers();
        for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
            completionHandler.handleProfileParsingCompletion(profileOps, list);
        }
        for (List subsystems : profileOps.values()) {
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void setOrganization(ModelNode address, List<ModelNode> operationList, ModelNode value) {
        if (value != null && value.isDefined() && value.asString().length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"organization", (ModelNode)value);
            operationList.add(update);
        }
    }

    private void setServerName(ModelNode address, List<ModelNode> operationList, ModelNode value) {
        if (value != null && value.isDefined() && value.asString().length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (ModelNode)value);
            operationList.add(update);
        }
    }

    void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.SERVER.getLocalName());
        if (modelNode.hasDefined("name")) {
            ServerRootResourceDefinition.NAME.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
        }
        if (modelNode.hasDefined(ServerRootResourceDefinition.ORGANIZATION_IDENTIFIER.getName())) {
            ServerRootResourceDefinition.ORGANIZATION_IDENTIFIER.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
        }
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        if (modelNode.hasDefined("extension")) {
            this.extensionHandler.writeExtensions(writer, modelNode.get("extension"));
        }
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, true);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"), false);
        }
        if (modelNode.hasDefined("core-service") && modelNode.get("core-service").hasDefined("vault")) {
            this.writeVault(writer, modelNode.get(new String[]{"core-service", "vault"}));
        }
        if (modelNode.hasDefined("core-service")) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)Namespace.CURRENT, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
        }
        this.writeServerProfile(writer, context);
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
        }
        if (modelNode.hasDefined("socket-binding-group")) {
            Set groups = modelNode.get("socket-binding-group").keys();
            if (groups.size() > 1) {
                throw ControllerLogger.ROOT_LOGGER.multipleModelNodes("socket-binding-group");
            }
            for (String group : groups) {
                this.writeSocketBindingGroup(writer, modelNode.get(new String[]{"socket-binding-group", group}), group);
            }
        }
        if (modelNode.hasDefined("deployment")) {
            this.writeServerDeployments(writer, modelNode.get("deployment"));
            WriteUtils.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("deployment-overlay")) {
            this.writeDeploymentOverlays(writer, modelNode.get("deployment-overlay"));
            WriteUtils.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void writeServerDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean deploymentWritten = false;
        for (String deploymentName : modelNode.keys()) {
            ModelNode deployment = modelNode.get(deploymentName);
            if (!deployment.isDefined()) continue;
            if (!deploymentWritten) {
                writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
                deploymentWritten = true;
            }
            writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)deploymentName);
            DeploymentAttributes.RUNTIME_NAME.marshallAsAttribute(deployment, (XMLStreamWriter)writer);
            DeploymentAttributes.ENABLED.marshallAsAttribute(deployment, (XMLStreamWriter)writer);
            List contentItems = deployment.require("content").asList();
            for (ModelNode contentItem : contentItems) {
                StandaloneXml_7.writeContentItem(writer, contentItem);
            }
            writer.writeEndElement();
        }
        if (deploymentWritten) {
            writer.writeEndElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServerProfile(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode profileNode = context.getModelNode();
        if (!profileNode.hasDefined("subsystem")) {
            return;
        }
        writer.writeStartElement(Element.PROFILE.getLocalName());
        Set subsystemNames = profileNode.get("subsystem").keys();
        if (subsystemNames.size() > 0) {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        writer.writeEndElement();
    }

    public boolean parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case NATIVE_INTERFACE: {
                    this.parseNativeManagementInterface(reader, address, list);
                    continue block5;
                }
                case HTTP_INTERFACE: {
                    this.parseHttpManagementInterface(reader, address, list);
                    continue block5;
                }
                case NATIVE_REMOTING_INTERFACE: {
                    this.parseNativeRemotingManagementInterface(reader, address, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return true;
    }

    public boolean parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        ModelNode accAuthzAddr = address.clone().add("access", "authorization");
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (null == attribute) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute) {
                case PROVIDER: {
                    ModelNode provider = AccessAuthorizationResourceDefinition.PROVIDER.getParser().parse((AttributeDefinition)AccessAuthorizationResourceDefinition.PROVIDER, value, (XMLStreamReader)reader);
                    ModelNode op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PROVIDER.getName(), (ModelNode)provider);
                    operationsList.add(op);
                    continue block9;
                }
                case USE_IDENTITY_ROLES: {
                    ModelNode useIdentityRoles = AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.getParser().parse((AttributeDefinition)AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES, value, (XMLStreamReader)reader);
                    ModelNode op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.getName(), (ModelNode)useIdentityRoles);
                    operationsList.add(op);
                    continue block9;
                }
                case PERMISSION_COMBINATION_POLICY: {
                    ModelNode provider = AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getParser().parse((AttributeDefinition)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY, value, (XMLStreamReader)reader);
                    ModelNode op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName(), (ModelNode)provider);
                    operationsList.add(op);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE_MAPPING: {
                    this.accessControlXml.parseAccessControlRoleMapping(reader, accAuthzAddr, operationsList);
                    continue block10;
                }
                case CONSTRAINTS: {
                    this.accessControlXml.parseAccessControlConstraints(reader, accAuthzAddr, operationsList);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return true;
    }

    public boolean parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.auditLogDelegate.parseAuditLog(reader, address, this.namespace, list);
        return true;
    }

    public boolean writeNativeManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.NATIVE_INTERFACE.getLocalName());
        NativeManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SSL_CONTEXT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SASL_PROTOCOL.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SERVER_NAME.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        if (NativeManagementResourceDefinition.SOCKET_BINDING.isMarshallable(protocol)) {
            writer.writeEmptyElement(Element.SOCKET_BINDING.getLocalName());
            NativeManagementResourceDefinition.SOCKET_BINDING.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
        return true;
    }

    public boolean writeHttpManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.HTTP_INTERFACE.getLocalName());
        HttpManagementResourceDefinition.HTTP_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SSL_CONTEXT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SASL_PROTOCOL.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SERVER_NAME.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        boolean consoleEnabled = protocol.get("console-enabled").asBoolean(true);
        if (!consoleEnabled) {
            HttpManagementResourceDefinition.CONSOLE_ENABLED.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        }
        HttpManagementResourceDefinition.ALLOWED_ORIGINS.getMarshaller().marshallAsAttribute((AttributeDefinition)HttpManagementResourceDefinition.ALLOWED_ORIGINS, protocol, true, (XMLStreamWriter)writer);
        if (HttpManagementResourceDefinition.HTTP_UPGRADE.isMarshallable(protocol)) {
            writer.writeEmptyElement(Element.HTTP_UPGRADE.getLocalName());
            HttpManagementResourceDefinition.ENABLED.marshallAsAttribute(protocol.require("http-upgrade"), (XMLStreamWriter)writer);
            HttpManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol.require("http-upgrade"), (XMLStreamWriter)writer);
        }
        if (HttpManagementResourceDefinition.SOCKET_BINDING.isMarshallable(protocol) || HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.isMarshallable(protocol)) {
            writer.writeEmptyElement(Element.SOCKET_BINDING.getLocalName());
            HttpManagementResourceDefinition.SOCKET_BINDING.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
            HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
        return true;
    }

    public boolean writeAccessControl(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
        this.accessControlXml.writeAccessControl(writer, accessAuthorization);
        return true;
    }

    public boolean writeAuditLog(XMLExtendedStreamWriter writer, ModelNode auditLog) throws XMLStreamException {
        this.auditLogDelegate.writeAuditLog(writer, auditLog);
        return true;
    }
}

