/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.DomainOperationTransmuter;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class AffectedDeploymentOverlay {
    private AffectedDeploymentOverlay() {
    }

    public static Set<String> listAllLinks(OperationContext context, String overlay) {
        Set<String> serverGoupNames = AffectedDeploymentOverlay.listServerGroupsReferencingOverlay(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), overlay);
        HashSet<String> links = new HashSet<String>();
        for (String serverGoupName : serverGoupNames) {
            links.addAll(AffectedDeploymentOverlay.listLinks(context, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group", (String)serverGoupName), PathElement.pathElement((String)"deployment-overlay", (String)overlay)})));
        }
        return links;
    }

    public static Set<String> listLinks(OperationContext context, PathAddress overlayAddress) {
        Resource overlayResource = context.readResourceFromRoot(overlayAddress);
        if (overlayResource.hasChildren("deployment")) {
            return overlayResource.getChildrenNames("deployment");
        }
        return Collections.emptySet();
    }

    public static void redeployLinks(OperationContext context, PathAddress deploymentsRootAddress, Set<String> runtimeNames) throws OperationFailedException {
        Set<String> deploymentNames = AffectedDeploymentOverlay.listDeployments(context.readResourceFromRoot(deploymentsRootAddress), runtimeNames);
        for (String deploymentName : deploymentNames) {
            PathAddress address = deploymentsRootAddress.append("deployment", deploymentName);
            OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(address, "redeploy");
            ModelNode operation = AffectedDeploymentOverlay.addRedeployStep(address);
            ServerLogger.AS_ROOT_LOGGER.debugf("Redeploying %s at address %s with handler %s", deploymentName, address, handler);
            assert (handler != null);
            assert (operation.isDefined());
            context.addStep(operation, handler, OperationContext.Stage.MODEL);
        }
    }

    public static void redeployDeployments(OperationContext context, PathAddress deploymentsRootAddress, Set<String> deploymentNames) throws OperationFailedException {
        for (String deploymentName : deploymentNames) {
            PathAddress address = deploymentsRootAddress.append("deployment", deploymentName);
            OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(address, "redeploy");
            ModelNode operation = AffectedDeploymentOverlay.addRedeployStep(address);
            ServerLogger.AS_ROOT_LOGGER.debugf("Redeploying %s at address %s with handler %s", deploymentName, address, handler);
            assert (handler != null);
            assert (operation.isDefined());
            context.addStep(operation, handler, OperationContext.Stage.MODEL);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void redeployLinksAndTransformOperationForDomain(OperationContext context, Set<String> runtimeNames, ModelNode removeOperation) throws OperationFailedException {
        void var6_12;
        Set<String> serverGroupNames = AffectedDeploymentOverlay.listServerGroupsReferencingOverlay(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), context.getCurrentAddressValue());
        HashMap<String, Set<String>> deploymentPerServerGroup = new HashMap<String, Set<String>>();
        for (String string : serverGroupNames) {
            deploymentPerServerGroup.put(string, AffectedDeploymentOverlay.listDeployments(context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"server-group", (String)string)})), runtimeNames));
        }
        if (deploymentPerServerGroup.isEmpty()) {
            for (String string : runtimeNames) {
                ServerLogger.ROOT_LOGGER.debugf("We haven't found any server-group for %s", string);
            }
        }
        Operations.CompositeOperationBuilder opBuilder = Operations.CompositeOperationBuilder.create();
        if (removeOperation != null) {
            opBuilder.addStep(removeOperation);
        }
        for (Map.Entry entry : deploymentPerServerGroup.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            for (String deploymentName : (Set)entry.getValue()) {
                opBuilder.addStep(AffectedDeploymentOverlay.addRedeployStep(context.getCurrentAddress().getParent().append("server-group", (String)entry.getKey()).append("deployment", deploymentName)));
            }
        }
        List list = (List)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (list == null) {
            ArrayList arrayList = new ArrayList();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, arrayList);
        }
        ModelNode modelNode = opBuilder.build().getOperation();
        var6_12.add(new OverlayOperationTransmuter(modelNode, context.getCurrentAddress()));
    }

    public static void redeployLinksAndTransformOperation(OperationContext context, ModelNode removeOperation, PathAddress deploymentsRootAddress, Set<String> runtimeNames) throws OperationFailedException {
        Set<String> deploymentNames = AffectedDeploymentOverlay.listDeployments(context.readResourceFromRoot(deploymentsRootAddress), runtimeNames);
        Operations.CompositeOperationBuilder opBuilder = Operations.CompositeOperationBuilder.create();
        if (deploymentNames.isEmpty()) {
            for (String s : runtimeNames) {
                ServerLogger.ROOT_LOGGER.debugf("We haven't found any deployment for %s in server-group %s", s, deploymentsRootAddress.getLastElement().getValue());
            }
        }
        if (removeOperation != null) {
            opBuilder.addStep(removeOperation);
        }
        for (String deploymentName : deploymentNames) {
            opBuilder.addStep(AffectedDeploymentOverlay.addRedeployStep(deploymentsRootAddress.append("deployment", deploymentName)));
        }
        ArrayList<OverlayOperationTransmuter> transformers = (ArrayList<OverlayOperationTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<OverlayOperationTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        ModelNode slave = opBuilder.build().getOperation();
        transformers.add(new OverlayOperationTransmuter(slave, context.getCurrentAddress()));
    }

    public static Set<String> listDeployments(Resource deploymentRootResource, Set<String> runtimeNames) {
        HashSet<Pattern> set = new HashSet<Pattern>();
        for (String wildcardExpr : runtimeNames) {
            Pattern pattern = DeploymentOverlayIndex.getPattern(wildcardExpr);
            set.add(pattern);
        }
        return AffectedDeploymentOverlay.listDeploymentNames(deploymentRootResource, set);
    }

    private static Set<String> listDeploymentNames(Resource deploymentRootResource, Set<Pattern> patterns) {
        HashSet<String> deploymentNames = new HashSet<String>();
        if (deploymentRootResource.hasChildren("deployment")) {
            for (Resource.ResourceEntry deploymentResource : deploymentRootResource.getChildren("deployment")) {
                if (AffectedDeploymentOverlay.isAcceptableDeployment(deploymentResource.getModel(), patterns)) {
                    deploymentNames.add(deploymentResource.getName());
                    continue;
                }
                if (!deploymentResource.hasChildren("subdeployment")) continue;
                for (Resource.ResourceEntry subdeploymentResource : deploymentResource.getChildren("subdeployment")) {
                    if (!AffectedDeploymentOverlay.isAcceptableDeployment(subdeploymentResource.getModel(), patterns)) continue;
                    deploymentNames.add(deploymentResource.getName());
                }
            }
        }
        return deploymentNames;
    }

    private static boolean isAcceptableDeployment(ModelNode deploymentNode, Set<Pattern> patterns) {
        return deploymentNode.isDefined() && deploymentNode.hasDefined("enabled") && deploymentNode.get("enabled").asBoolean() && patterns.stream().anyMatch(pattern -> pattern.matcher(deploymentNode.require("runtime-name").asString()).matches());
    }

    private static ModelNode addRedeployStep(PathAddress address) {
        return Operations.createOperation((String)"redeploy", (ModelNode)address.toModelNode());
    }

    private static Set<String> listServerGroupsReferencingOverlay(Resource rootResource, String overlayName) {
        PathElement overlayPath = PathElement.pathElement((String)"deployment-overlay", (String)overlayName);
        if (rootResource.hasChildren("server-group")) {
            HashSet<String> set = new HashSet<String>();
            for (String serverGroupName : rootResource.getChildrenNames("server-group")) {
                if (!rootResource.getChild(PathElement.pathElement((String)"server-group", (String)serverGroupName)).hasChild(overlayPath)) continue;
                set.add(serverGroupName);
            }
            return set;
        }
        return Collections.emptySet();
    }

    private static final class OverlayOperationTransmuter
    implements DomainOperationTransmuter {
        private final ModelNode newOperation;
        private final PathAddress overlayAddress;

        public OverlayOperationTransmuter(ModelNode newOperation, PathAddress overlayAddress) {
            this.newOperation = newOperation;
            this.overlayAddress = overlayAddress;
        }

        public ModelNode transmmute(OperationContext context, ModelNode operation) {
            if ("composite".equals(operation.get("operation").asString())) {
                ModelNode ret = operation.clone();
                ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                ListIterator it = ret.get("steps").asList().listIterator();
                while (it.hasNext()) {
                    ModelNode subOperation = (ModelNode)it.next();
                    list.add(this.transmmute(context, subOperation));
                }
                ret.get("steps").set(list);
                ServerLogger.AS_ROOT_LOGGER.debugf("Transforming operation %s into %s", operation.toJSONString(true), ret.toJSONString(true));
                return ret;
            }
            if (this.matches(operation)) {
                ServerLogger.AS_ROOT_LOGGER.debugf("Transforming operation %s into %s", operation.toJSONString(true), this.newOperation.toJSONString(true));
                return this.newOperation.clone();
            }
            return operation;
        }

        protected boolean matches(ModelNode operation) {
            return ("redeploy-links".equals(operation.get("operation").asString()) || "remove".equals(operation.get("operation").asString()) && operation.hasDefined("redeploy-affected") && operation.get("redeploy-affected").asBoolean()) && this.validOverlay(PathAddress.pathAddress((ModelNode)operation.get("address")));
        }

        private boolean validOverlay(PathAddress operationAddress) {
            if (operationAddress.size() >= 1 && operationAddress.size() >= this.overlayAddress.size()) {
                ServerLogger.AS_ROOT_LOGGER.debugf("Comparing address %s with %s", operationAddress.subAddress(0, this.overlayAddress.size()).toCLIStyleString(), this.overlayAddress.toCLIStyleString());
                return operationAddress.subAddress(0, this.overlayAddress.size()).equals(this.overlayAddress);
            }
            return false;
        }
    }
}

