/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.AbstractMechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;
import org.wildfly.security.sasl.util.SaslFactories;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.sasl.util.TrustManagerSaslServerFactory;

public final class SaslAuthenticationFactory
extends AbstractMechanismAuthenticationFactory<SaslServer, SaslException> {
    private final SaslServerFactory saslServerFactory;
    static final Map<String, String> QUERY_ALL = Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true");

    SaslAuthenticationFactory(SecurityDomain securityDomain, Map<String, MechanismConfiguration> mechanismConfigurations, SaslServerFactory saslServerFactory) {
        super(securityDomain, mechanismConfigurations);
        this.saslServerFactory = saslServerFactory;
    }

    public SaslServerFactory getSaslServerFactory() {
        return this.saslServerFactory;
    }

    @Override
    SaslServer doCreate(String name, CallbackHandler callbackHandler) throws SaslException {
        return this.saslServerFactory.createSaslServer(name, "unknown", null, QUERY_ALL, callbackHandler);
    }

    @Override
    Collection<String> getAllSupportedMechNames() {
        String[] names = this.saslServerFactory.getMechanismNames(Collections.singletonMap("wildfly.sasl.mechanism-query-all", "true"));
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        if (names.length == 1) {
            return Collections.singletonList(names[0]);
        }
        return Arrays.asList(names);
    }

    @Override
    Collection<Class<? extends Evidence>> getSupportedEvidenceTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceTypes(mechName);
    }

    @Override
    Collection<String> getSupportedEvidenceAlgorithmNames(Class<? extends AlgorithmEvidence> evidenceType, String mechName) {
        return SaslMechanismInformation.getSupportedServerEvidenceAlgorithms(mechName, evidenceType);
    }

    @Override
    Collection<Class<? extends Credential>> getSupportedCredentialTypes(String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialTypes(mechName);
    }

    @Override
    Collection<String> getSupportedCredentialAlgorithmNames(Class<? extends AlgorithmCredential> credentialType, String mechName) {
        return SaslMechanismInformation.getSupportedServerCredentialAlgorithms(mechName, credentialType);
    }

    @Override
    boolean usesCredentials(String mechName) {
        return SaslMechanismInformation.needsServerCredentials(mechName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractMechanismAuthenticationFactory.Builder<SaslServer, SaslException> {
        private SaslServerFactory saslServerFactory = SaslFactories.getEmptySaslServerFactory();

        Builder() {
        }

        @Override
        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            super.setSecurityDomain(securityDomain);
            return this;
        }

        @Override
        public Builder addMechanism(String mechanismName, MechanismConfiguration mechanismConfiguration) {
            super.addMechanism(mechanismName, mechanismConfiguration);
            return this;
        }

        public Builder setSaslServerFactory(SaslServerFactory saslServerFactory) {
            Assert.checkNotNullParam((String)"saslServerFactory", (Object)saslServerFactory);
            this.saslServerFactory = saslServerFactory;
            return this;
        }

        public SaslAuthenticationFactory build() {
            AbstractDelegatingSaslServerFactory factory = new AuthenticationCompleteCallbackSaslServerFactory(this.saslServerFactory);
            if (!factory.delegatesThrough(TrustManagerSaslServerFactory.class)) {
                factory = new TrustManagerSaslServerFactory(factory, null);
            }
            return new SaslAuthenticationFactory(this.getSecurityDomain(), this.getMechanismConfigurations(), factory);
        }
    }
}

