/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.EnumSet;

public enum SupportLevel {
    UNSUPPORTED,
    POSSIBLY_SUPPORTED,
    SUPPORTED;

    private static final int fullSize;

    public boolean isDefinitelySupported() {
        return this == SUPPORTED;
    }

    public boolean mayBeSupported() {
        return this != UNSUPPORTED;
    }

    public boolean isNotSupported() {
        return this == UNSUPPORTED;
    }

    public static boolean isFull(EnumSet<SupportLevel> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(SupportLevel v1) {
        return this == v1;
    }

    public boolean in(SupportLevel v1, SupportLevel v2) {
        return this == v1 || this == v2;
    }

    public boolean in(SupportLevel v1, SupportLevel v2, SupportLevel v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(SupportLevel ... values) {
        if (values != null) {
            for (SupportLevel value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = SupportLevel.values().length;
    }
}

