/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.util.Locale;
import java.util.regex.Pattern;
import org.wildfly.common.math.HashMath;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.MatchRule;

class MatchHostRule
extends MatchRule {
    private static final Pattern validHostSpecPattern = Pattern.compile("(?i:[-a-z0-9_]+(?:\\.[-a-z0-9_]+)*\\.?)");
    private final String hostSpec;

    MatchHostRule(MatchRule parent, String hostSpec) {
        super(parent);
        if (!validHostSpecPattern.matcher(hostSpec).matches()) {
            throw ElytronMessages.log.invalidHostSpec(hostSpec);
        }
        this.hostSpec = hostSpec.endsWith(".") ? hostSpec.substring(0, hostSpec.length() - 1).toLowerCase(Locale.ENGLISH) : hostSpec.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority, String purpose) {
        String host = uri.getHost();
        return host != null && host.startsWith(this.hostSpec) && super.matches(uri, abstractType, abstractTypeAuthority, purpose);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchHostRule(newParent, this.hostSpec);
    }

    @Override
    public String getMatchHost() {
        return this.hostSpec;
    }

    @Override
    public boolean isHostMatched() {
        return true;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)2011, (int)this.hostSpec.hashCode());
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.hostSpec.equals(other.getMatchHost()) && this.parentHalfEqual(other);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("host=").append(this.hostSpec).append(',');
    }
}

