/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.external.ExternalSaslServer;
import org.wildfly.security.util._private.Arrays2;

public final class ExternalSaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return mechanism.equals("EXTERNAL") ? new ExternalSaslServer(cbh) : null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all"))) {
            return Arrays2.of("EXTERNAL");
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noactive"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.forward"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noplaintext"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noanonymous"))) {
            return WildFlySasl.NO_NAMES;
        }
        if ("true".equals(props.get("javax.security.sasl.policy.nodictionary"))) {
            return WildFlySasl.NO_NAMES;
        }
        return Arrays2.of("EXTERNAL");
    }
}

