/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslServer;

public final class PrivilegedSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final AccessControlContext context;

    public PrivilegedSaslServerFactory(SaslServerFactory delegate) {
        this(delegate, AccessController.getContext());
    }

    PrivilegedSaslServerFactory(SaslServerFactory delegate, AccessControlContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslServer saslServer = this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
        return saslServer == null ? null : new PrivilegedSaslServer(saslServer, this.context);
    }
}

