/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import javax.security.auth.x500.X500Principal;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;

public final class X509CertificateEvidenceDecoder
implements EvidenceDecoder {
    private static final X509CertificateEvidenceDecoder INSTANCE = new X509CertificateEvidenceDecoder();

    private X509CertificateEvidenceDecoder() {
    }

    @Override
    public X500Principal getPrincipalFromEvidence(Evidence evidence) {
        if (evidence instanceof X509PeerCertificateChainEvidence) {
            return ((X509PeerCertificateChainEvidence)evidence).getFirstCertificate().getSubjectX500Principal();
        }
        return null;
    }

    public static X509CertificateEvidenceDecoder getInstance() {
        return INSTANCE;
    }
}

