/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.ssl.TLSServerEndPointChannelBinding;
import org.wildfly.security.x500.X500;

public final class TLSServerEndPointChannelBindingSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    public TLSServerEndPointChannelBindingSaslClientFactory(SaslClientFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        return super.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, new CallbackHandler(){
            private X509Certificate[] peerCerts;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
                Iterator<Callback> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Callback callback = iterator.next();
                    if (callback instanceof SSLCallback) {
                        SSLCallback sslCallback = (SSLCallback)callback;
                        this.peerCerts = X500.asX509CertificateArray(sslCallback.getSslSession().getPeerCertificates());
                        continue;
                    }
                    if (!(callback instanceof ChannelBindingCallback)) continue;
                    TLSServerEndPointChannelBinding.handleChannelBindingCallback((ChannelBindingCallback)callback, this.peerCerts);
                    iterator.remove();
                }
                if (!list.isEmpty()) {
                    cbh.handle(list.toArray(new Callback[list.size()]));
                }
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TLSServerEndPointChannelBindingSaslClientFactory && this.equals((TLSServerEndPointChannelBindingSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof TLSServerEndPointChannelBindingSaslClientFactory && this.equals((TLSServerEndPointChannelBindingSaslClientFactory)other);
    }

    public boolean equals(TLSServerEndPointChannelBindingSaslClientFactory other) {
        return super.equals(other);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered((int)super.calculateHashCode(), (int)this.getClass().hashCode());
    }
}

