/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.impl.BaseHttpServerRequest;
import org.wildfly.security.http.util.SimpleHttpServerCookie;
import org.wildfly.security.http.util.sso.SingleSignOnConfiguration;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;

public class ProgrammaticSingleSignOnCache
implements IdentityCache {
    private final HttpExchangeSpi httpExchangeSpi;
    private final String mechanismName;
    private final SingleSignOnSessionFactory singleSignOnSessionFactory;
    private final SingleSignOnConfiguration configuration;
    private volatile HttpServerRequest httpServerRequest;
    private volatile String ssoSessionId;

    ProgrammaticSingleSignOnCache(HttpExchangeSpi httpExchangeSpi, String mechanismName, SingleSignOnSessionFactory singleSignOnSessionFactory, SingleSignOnConfiguration configuration) {
        this.httpExchangeSpi = (HttpExchangeSpi)Assert.checkNotNullParam((String)"httpExchangeSpi", (Object)httpExchangeSpi);
        this.mechanismName = (String)Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        this.singleSignOnSessionFactory = (SingleSignOnSessionFactory)Assert.checkNotNullParam((String)"singleSignOnSessionFactory", (Object)singleSignOnSessionFactory);
        this.configuration = (SingleSignOnConfiguration)Assert.checkNotNullParam((String)"configuration", (Object)configuration);
    }

    @Override
    public CachedIdentity get() {
        try (SingleSignOnSession singleSignOnSession = this.getSingleSignOnSession(false);){
            if (singleSignOnSession == null) {
                if (this.ssoSessionId != null && this.ssoSessionId.length() > 0) {
                    this.clearCookie();
                }
                CachedIdentity cachedIdentity = null;
                return cachedIdentity;
            }
            if (singleSignOnSession.logout()) {
                singleSignOnSession.close();
                CachedIdentity cachedIdentity = null;
                return cachedIdentity;
            }
            CachedIdentity cachedIdentity = singleSignOnSession.get();
            if (cachedIdentity != null && cachedIdentity.isProgrammatic() && this.mechanismName.equals(cachedIdentity.getMechanismName())) {
                CachedIdentity cachedIdentity2 = cachedIdentity;
                return cachedIdentity2;
            }
            CachedIdentity cachedIdentity3 = null;
            return cachedIdentity3;
        }
    }

    @Override
    public void put(SecurityIdentity identity) {
        try (SingleSignOnSession singleSignOnSession = this.getSingleSignOnSession(true);){
            singleSignOnSession.put(identity);
            this.ssoSessionId = singleSignOnSession.getId();
            this.setCookie();
        }
    }

    @Override
    public CachedIdentity remove() {
        try (SingleSignOnSession singleSignOnSession = this.getSingleSignOnSession(false);){
            if (this.getCookie() != null) {
                this.clearCookie();
            }
            if (singleSignOnSession != null) {
                CachedIdentity cachedIdentity = singleSignOnSession.remove();
                return cachedIdentity;
            }
        }
        return null;
    }

    private HttpServerRequest getOrCreateHttpServerRequest() {
        if (this.httpServerRequest == null) {
            this.httpServerRequest = new SSOHttpServerRequest(this.httpExchangeSpi);
        }
        return this.httpServerRequest;
    }

    private String getSSOSessionId() {
        if (this.ssoSessionId == null) {
            HttpServerCookie cookie = this.getCookie();
            this.ssoSessionId = cookie != null ? cookie.getValue() : "";
        }
        return this.ssoSessionId;
    }

    private SingleSignOnSession getSingleSignOnSession(boolean create) {
        SingleSignOnSession singleSignOnSession;
        String ssoSessionId = this.getSSOSessionId();
        SingleSignOnSession singleSignOnSession2 = singleSignOnSession = ssoSessionId != null && ssoSessionId.length() > 0 ? this.singleSignOnSessionFactory.find(ssoSessionId, this.getOrCreateHttpServerRequest()) : null;
        if (singleSignOnSession == null && create) {
            singleSignOnSession = this.singleSignOnSessionFactory.create(this.getOrCreateHttpServerRequest(), this.mechanismName, true);
        }
        return singleSignOnSession;
    }

    private HttpServerCookie getCookie() {
        String expectedCookieName = this.configuration.getCookieName();
        for (HttpServerCookie currentCookie : this.httpExchangeSpi.getCookies()) {
            if (!expectedCookieName.equals(currentCookie.getName())) continue;
            return currentCookie;
        }
        return null;
    }

    private void setCookie() {
        this.httpExchangeSpi.setResponseCookie(SimpleHttpServerCookie.newInstance(this.configuration.getCookieName(), this.ssoSessionId, this.configuration.getDomain(), -1, this.configuration.getPath(), this.configuration.isSecure(), 0, this.configuration.isHttpOnly()));
    }

    private void clearCookie() {
        this.ssoSessionId = null;
        this.httpExchangeSpi.setResponseCookie(SimpleHttpServerCookie.newInstance(this.configuration.getCookieName(), null, this.configuration.getDomain(), 0, this.configuration.getPath(), this.configuration.isSecure(), 0, this.configuration.isHttpOnly()));
    }

    public static IdentityCache newInstance(HttpExchangeSpi httpExchangeSpi, String mechanismName, SingleSignOnSessionFactory singleSignOnSessionFactory, SingleSignOnConfiguration configuration) {
        return new ProgrammaticSingleSignOnCache(httpExchangeSpi, mechanismName, singleSignOnSessionFactory, configuration);
    }

    private static class SSOHttpServerRequest
    extends BaseHttpServerRequest {
        SSOHttpServerRequest(HttpExchangeSpi httpExchangeSpi) {
            super(httpExchangeSpi);
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
            throw new IllegalStateException();
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            throw new IllegalStateException();
        }

        @Override
        public boolean suspendRequest() {
            throw new IllegalStateException();
        }

        @Override
        public boolean resumeRequest() {
            throw new IllegalStateException();
        }
    }
}

