/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.authz.MappedRoles;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

public class MappedRoleMapper
implements RoleMapper {
    private final Map<String, Set<String>> reverseRoleMap = new LinkedHashMap<String, Set<String>>();
    private volatile boolean initialized = false;

    public MappedRoleMapper() {
    }

    private MappedRoleMapper(Map<String, Set<String>> roleMap) {
        Set<Map.Entry<String, Set<String>>> entrySet = roleMap.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            for (String mappedRole : entry.getValue()) {
                Set<String> rolesToMappedRole = this.reverseRoleMap.get(mappedRole);
                if (rolesToMappedRole == null) {
                    rolesToMappedRole = new LinkedHashSet<String>();
                    this.reverseRoleMap.put(mappedRole, rolesToMappedRole);
                }
                rolesToMappedRole.add(entry.getKey());
            }
        }
        this.initialized = true;
    }

    public void initialize(Map<String, String> configuration) {
        if (this.initialized) {
            throw ElytronMessages.log.roleMappedAlreadyInitialized();
        }
        this.reverseRoleMap.clear();
        configuration.forEach((key, value) -> {
            String[] newRoles;
            for (String newRole : newRoles = value.split("\\s+")) {
                Set<String> rolesToMappedRole = this.reverseRoleMap.get(newRole);
                if (rolesToMappedRole == null) {
                    rolesToMappedRole = new LinkedHashSet<String>();
                    this.reverseRoleMap.put(newRole, rolesToMappedRole);
                }
                rolesToMappedRole.add((String)key);
            }
        });
        this.initialized = true;
    }

    @Override
    public Roles mapRoles(Roles rolesToMap) {
        if (!this.initialized) {
            throw ElytronMessages.log.roleMappedNotInitialized();
        }
        return new MappedRoles(rolesToMap, this.reverseRoleMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Set<String>> roleMap;

        Builder() {
        }

        public MappedRoleMapper build() {
            return new MappedRoleMapper(this.roleMap);
        }

        public Builder setRoleMap(Map<String, Set<String>> roleMap) {
            this.roleMap = roleMap;
            return this;
        }
    }
}

