/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.wildfly.security.http.oidc.ClientSecretCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class JWTClientSecretCredentialsProvider
implements ClientSecretCredentialsProvider {
    private SecretKey clientSecret;
    private String clientSecretJwtAlg;
    private int tokenTimeout;

    @Override
    public String getId() {
        return Oidc.ClientCredentialsProviderType.SECRET_JWT.getValue();
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    protected int getTokenTimeout() {
        return this.tokenTimeout;
    }

    @Override
    public void init(OidcClientConfiguration oidcClientConfiguration, Object credentialsConfig) {
        if (!(credentialsConfig instanceof Map)) {
            throw ElytronMessages.log.invalidJwtClientCredentialsUsingSecretConfig(oidcClientConfiguration.getResourceName());
        }
        Map cfg = (Map)credentialsConfig;
        String clientSecretString = (String)cfg.get("secret");
        if (clientSecretString == null) {
            throw ElytronMessages.log.missingParameterInJwtClientCredentialsConfig("secret", oidcClientConfiguration.getResourceName());
        }
        String clientSecretJwtAlg = (String)cfg.get("algorithm");
        if (clientSecretJwtAlg == null) {
            this.setClientSecret(clientSecretString);
        } else if (this.isValidClientSecretJwtAlg(clientSecretJwtAlg)) {
            this.setClientSecret(clientSecretString, clientSecretJwtAlg);
        } else {
            throw ElytronMessages.log.invalidAlgorithmInJwtClientCredentialsConfig(oidcClientConfiguration.getResourceName());
        }
        this.tokenTimeout = Oidc.asInt(cfg, "token-timeout", 10);
    }

    private boolean isValidClientSecretJwtAlg(String clientSecretJwtAlg) {
        boolean valid = false;
        if ("HS256".equals(clientSecretJwtAlg) || "HS384".equals(clientSecretJwtAlg) || "HS512".equals(clientSecretJwtAlg)) {
            valid = true;
        }
        return valid;
    }

    @Override
    public void setClientCredentials(OidcClientConfiguration oidcClientConfiguration, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(oidcClientConfiguration.getResourceName(), oidcClientConfiguration.getTokenUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    @Override
    public SecretKey getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecretString) {
        this.setClientSecret(clientSecretString, "HS256");
    }

    public void setClientSecret(String clientSecretString, String algorithm) {
        this.clientSecret = new SecretKeySpec(clientSecretString.getBytes(StandardCharsets.UTF_8), Oidc.getJavaAlgorithm(algorithm));
        this.clientSecretJwtAlg = algorithm;
    }

    public String createSignedRequestToken(String clientId, String tokenUrl) {
        return this.createSignedRequestToken(clientId, tokenUrl, this.clientSecretJwtAlg);
    }

    public String createSignedRequestToken(String clientId, String tokenUrl, String algorithm) {
        JwtClaims jwtClaims = this.createRequestToken(clientId, tokenUrl);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKey(this.clientSecret);
        jws.setAlgorithmHeaderValue(this.clientSecretJwtAlg);
        jws.setPayload(jwtClaims.toJson());
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw ElytronMessages.log.unableToCreateSignedToken();
        }
    }

    private JwtClaims createRequestToken(String clientId, String tokenUrl) {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setJwtId(Oidc.generateId());
        jwtClaims.setIssuer(clientId);
        jwtClaims.setSubject(clientId);
        jwtClaims.setAudience(tokenUrl);
        NumericDate now = NumericDate.now();
        jwtClaims.setIssuedAt(now);
        jwtClaims.setNotBefore(now);
        NumericDate exp = NumericDate.fromSeconds(now.getValue() + (long)this.tokenTimeout);
        jwtClaims.setExpirationTime(exp);
        return jwtClaims;
    }
}

