/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.PrivilegedServerMechanism;

public final class PrivilegedServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final AccessControlContext accessControlContext;

    public PrivilegedServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, AccessControlContext accessControlContext) {
        this.delegate = (HttpServerAuthenticationMechanismFactory)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        this.accessControlContext = (AccessControlContext)Assert.checkNotNullParam((String)"accessControlContext", (Object)accessControlContext);
    }

    public PrivilegedServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate) {
        this(delegate, AccessController.getContext());
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        HttpServerAuthenticationMechanism serverMechanism = this.delegate.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
        return serverMechanism != null ? new PrivilegedServerMechanism(serverMechanism, this.accessControlContext) : null;
    }
}

