/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.config;

import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.KeyUtils;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String NONE = "NONE";
    @Inject
    @ConfigProperty(name="mpjwt.signerPublicKey", defaultValue="NONE")
    private Optional<String> publicKeyPemEnc;
    @Inject
    @ConfigProperty(name="mpjwt.issuedBy", defaultValue="NONE")
    private String issuedBy;
    @Inject
    @ConfigProperty(name="mpjwt.expGracePeriodSecs", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="mpjwt.jwksUri", defaultValue="NONE")
    private Optional<String> jwksUri;
    @Inject
    @ConfigProperty(name="mpjwt.jwksRefreshInterval", defaultValue="60")
    private Optional<Integer> jwksRefreshInterval;

    @PostConstruct
    void init() {
    }

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        if (NONE.equals(this.publicKeyPemEnc.get()) && NONE.equals(this.jwksUri.get())) {
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.publicKeyPemEnc.isPresent() && !NONE.equals(this.publicKeyPemEnc.get())) {
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.publicKeyPemEnc.get());
                contextInfo.setSignerKey(pk);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        if (this.issuedBy != null && !this.issuedBy.equals(NONE)) {
            contextInfo.setIssuedBy(this.issuedBy);
        }
        if (this.expGracePeriodSecs.isPresent()) {
            contextInfo.setExpGracePeriodSecs(this.expGracePeriodSecs.get());
        }
        if (this.jwksUri.isPresent() && !NONE.equals(this.jwksUri.get())) {
            contextInfo.setJwksUri(this.jwksUri.get());
        }
        if (this.jwksRefreshInterval.isPresent()) {
            contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval.get());
        }
        return Optional.of(contextInfo);
    }

    @Produces
    JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

