/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas;

import io.undertow.security.idm.Credential;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;

public class JWTCredential
implements Credential {
    private JWTAuthContextInfo authContextInfo;
    private String bearerToken;
    private String name;
    private Exception jwtException;

    public JWTCredential(String bearerToken, JWTAuthContextInfo authContextInfo) {
        this.bearerToken = bearerToken;
        this.authContextInfo = authContextInfo;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "INVALID_TOKEN_NAME";
            try {
                JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
                JwtContext jwtContext = firstPassJwtConsumer.process(this.bearerToken);
                JwtClaims claimsSet = jwtContext.getJwtClaims();
                this.name = (String)claimsSet.getClaimValue("upn", String.class);
                if (this.name == null) {
                    this.name = (String)claimsSet.getClaimValue("preferred_username", String.class);
                    if (this.name == null) {
                        this.name = claimsSet.getSubject();
                    }
                }
            }
            catch (Exception e) {
                this.jwtException = e;
            }
        }
        return this.name;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public JWTAuthContextInfo getAuthContextInfo() {
        return this.authContextInfo;
    }

    public Exception getJwtException() {
        return this.jwtException;
    }
}

