/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.SecurityAssociationCallback;
import org.jboss.security.auth.spi.RoleMappingLoginModule;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas.JWTCredential;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTCallerPrincipal;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTCallerPrincipalFactory;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.ParseException;

public class JWTLoginModule
extends RoleMappingLoginModule {
    private static final String LOG_EXCEPTIONS = "logExceptions";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"logExceptions"};
    private JsonWebToken jwtPrincipal;
    private boolean logExceptions = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        if (options.containsKey(LOG_EXCEPTIONS)) {
            this.logExceptions = Boolean.valueOf(options.get(LOG_EXCEPTIONS).toString());
        }
    }

    public boolean login() throws LoginException {
        SecurityAssociationCallback sac = new SecurityAssociationCallback();
        try {
            this.callbackHandler.handle(new Callback[]{sac});
            JWTCredential jwtCredential = (JWTCredential)sac.getCredential();
            this.jwtPrincipal = this.validate(jwtCredential);
        }
        catch (Exception e) {
            if (this.logExceptions) {
                this.log.infof((Throwable)e, "Failed to validate token", new Object[0]);
            }
            LoginException ex = new LoginException("Failed to validate token");
            ex.initCause(e);
            throw ex;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)this.jwtPrincipal);
        SimpleGroup roles = new SimpleGroup("Roles");
        for (String name : this.jwtPrincipal.getGroups()) {
            roles.addMember((Principal)new SimplePrincipal(name));
        }
        this.subject.getPrincipals().add((Principal)roles);
        this.sharedState.put("JsonWebToken", this.jwtPrincipal);
        return super.commit();
    }

    protected JWTCallerPrincipal validate(JWTCredential jwtCredential) throws ParseException {
        JWTCallerPrincipalFactory factory = JWTCallerPrincipalFactory.instance();
        JWTCallerPrincipal callerPrincipal = factory.parse(jwtCredential.getBearerToken(), jwtCredential.getAuthContextInfo());
        return callerPrincipal;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.options.containsKey("rolesProperties")) {
            return super.getRoleSets();
        }
        Principal group = this.subject.getPrincipals().stream().filter(p -> p instanceof Group && "Roles".equals(p.getName())).findFirst().get();
        return new Group[]{(Group)group};
    }
}

