/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.microprofile.jwtauth.MicroProfileJWTAuthFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebAsset;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class MPJWTAuthExtensionArchivePreparer
implements DeploymentProcessor {
    private static Logger log = Logger.getLogger(MPJWTAuthExtensionArchivePreparer.class);
    private static final DotName LOGIN_CONFIG = DotName.createSimple((String)"org.eclipse.microprofile.auth.LoginConfig");
    private static final DotName ROLES_ALLOWED = DotName.createSimple((String)"javax.annotation.security.RolesAllowed");
    private static final DotName DENY_ALL = DotName.createSimple((String)"javax.annotation.security.DenyAll");
    private static final DotName PERMIT_ALL = DotName.createSimple((String)"javax.annotation.security.PermitAll");
    private static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final DotName APP_PATH = DotName.createSimple((String)"javax.ws.rs.ApplicationPath");
    private static final DotName HTTP_METHOD = DotName.createSimple((String)"javax.ws.rs.HttpMethod");
    private static final DotName GET = DotName.createSimple((String)"javax.ws.rs.GET");
    private static final DotName POST = DotName.createSimple((String)"javax.ws.rs.POST");
    private static final DotName PUT = DotName.createSimple((String)"javax.ws.rs.PUT");
    private static final DotName DELETE = DotName.createSimple((String)"javax.ws.rs.DELETE");
    private static final DotName HEAD = DotName.createSimple((String)"javax.ws.rs.HEAD");
    private static final DotName OPTIONS = DotName.createSimple((String)"javax.ws.rs.OPTIONS");
    private static final String[] EMPTY_ROLES = new String[0];
    private final Archive archive;
    private final IndexView index;
    @Inject
    private MicroProfileJWTAuthFraction fraction;

    @Inject
    public MPJWTAuthExtensionArchivePreparer(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() throws Exception {
        String publicKey;
        WARArchive war = (WARArchive)this.archive.as(WARArchive.class);
        Collection lcAnnotations = this.index.getAnnotations(LOGIN_CONFIG);
        for (AnnotationInstance lc : lcAnnotations) {
            String realm;
            AnnotationValue authMethod = lc.value("authMethod");
            AnnotationValue realmName = lc.value("realmName");
            String string = realm = realmName != null ? realmName.asString() : "";
            if (authMethod != null) {
                WebXmlAsset webXml = war.findWebXmlAsset();
                webXml.setLoginConfig(authMethod.asString(), realm);
            }
            if (realm.length() <= 0) continue;
            JBossWebAsset jBossWeb = war.findJbossWebAsset();
            jBossWeb.setSecurityDomain(realm);
        }
        WebXmlAsset webXml = war.findWebXmlAsset();
        String appPath = "/";
        Collection appPaths = this.index.getAnnotations(APP_PATH);
        if (!appPaths.isEmpty()) {
            appPath = ((AnnotationInstance)appPaths.iterator().next()).value().asString();
        }
        Iterable<DotName> httpMethods = this.collectHttpMethods();
        HashSet<DotName> scannedClasses = new HashSet<DotName>();
        ArrayList securityAnnotations = new ArrayList();
        securityAnnotations.addAll(this.index.getAnnotations(ROLES_ALLOWED));
        securityAnnotations.addAll(this.index.getAnnotations(PERMIT_ALL));
        securityAnnotations.addAll(this.index.getAnnotations(DENY_ALL));
        for (AnnotationInstance annotation : securityAnnotations) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                ClassInfo classInfo2 = annotation.target().asClass();
                if (scannedClasses.contains(classInfo2.name())) continue;
                this.generateSecurityConstraints(webXml, classInfo2, appPath, httpMethods, scannedClasses);
                continue;
            }
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || scannedClasses.contains((classInfo = (methodInfo = annotation.target().asMethod()).declaringClass()).name())) continue;
            this.generateSecurityConstraints(webXml, classInfo, appPath, httpMethods, scannedClasses);
        }
        if (this.fraction.getTokenIssuer().isPresent()) {
            log.debugf("Issuer: %s", this.fraction.getTokenIssuer().get());
            war.addAsManifestResource((Asset)new StringAsset((String)this.fraction.getTokenIssuer().get()), "MP-JWT-ISSUER");
        }
        if ((publicKey = this.fraction.getPublicKey()) != null) {
            log.debugf("PublicKey: %s", (Object)publicKey);
            if (publicKey.startsWith("file:")) {
                File fileRef = new File(publicKey.substring(5, publicKey.length()));
                war.addAsManifestResource((Asset)new FileAsset(fileRef), "MP-JWT-SIGNER");
            } else if (publicKey.startsWith("classpath:")) {
                String cpref = publicKey.substring(10, publicKey.length());
                Node node = this.archive.get("WEB-INF/classes/" + cpref);
                war.addAsManifestResource(node.getAsset(), "MP-JWT-SIGNER");
            } else {
                war.addAsManifestResource((Asset)new StringAsset(publicKey), "MP-JWT-SIGNER");
            }
        }
        if (this.fraction.getJwksUri() != null) {
            log.debugf("JwksUri: %s", (Object)this.fraction.getJwksUri());
            war.addAsManifestResource((Asset)new StringAsset(this.fraction.getJwksUri()), "MP-JWT-JWKS");
            war.addAsManifestResource((Asset)new StringAsset(((Integer)this.fraction.getJwksRefreshInterval().get()).toString()), "MP-JWT-JWKS-REFRESH");
            if (this.fraction.getPublicKey() != null) {
                log.warn((Object)"The 'signer-pub-key' and 'jwks-uri' configuration options are mutually exclusive, the 'jwks-uri' will be ignored.");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("war: " + war.toString(true)));
        }
    }

    private void generateSecurityConstraints(WebXmlAsset webXml, ClassInfo classInfo, String appPath, Iterable<DotName> httpMethods, Set<DotName> scannedClasses) {
        ArrayList<SecurityConstraint> newConstraints;
        block16: {
            AnnotationInstance classPermitAll;
            AnnotationInstance classDenyAll;
            AnnotationInstance classRolesAllowed;
            String[] localRoles;
            StringBuilder fullAppPath;
            List<MethodInfo> resourceMethods;
            block17: {
                String uriPath;
                block19: {
                    block18: {
                        resourceMethods = this.getResourceMethods(classInfo, httpMethods);
                        if (resourceMethods.isEmpty()) {
                            return;
                        }
                        fullAppPath = new StringBuilder(appPath);
                        if (fullAppPath.charAt(fullAppPath.length() - 1) != '/') {
                            fullAppPath.append('/');
                        }
                        newConstraints = new ArrayList<SecurityConstraint>();
                        Optional<AnnotationInstance> rooPath = classInfo.classAnnotations().stream().filter(a -> a.name().equals((Object)PATH)).findFirst();
                        if (rooPath.isPresent()) {
                            String subpath = rooPath.get().value().asString();
                            if (subpath.charAt(0) == '/') {
                                fullAppPath.append(subpath.substring(1));
                            } else {
                                fullAppPath.append(subpath);
                            }
                            if (fullAppPath.charAt(fullAppPath.length() - 1) != '/') {
                                fullAppPath.append('/');
                            }
                        }
                        Iterator<MethodInfo> iterator = resourceMethods.iterator();
                        while (iterator.hasNext()) {
                            MethodInfo resourceMethod = iterator.next();
                            AnnotationInstance path = resourceMethod.annotation(PATH);
                            String subpath = path != null ? path.value().asString() : "";
                            AnnotationInstance rolesAllowed = resourceMethod.annotation(ROLES_ALLOWED);
                            AnnotationInstance denyAll = resourceMethod.annotation(DENY_ALL);
                            AnnotationInstance permitAll = resourceMethod.annotation(PERMIT_ALL);
                            if (rolesAllowed == null && denyAll == null && permitAll == null) continue;
                            localRoles = null;
                            if (permitAll != null) {
                                localRoles = EMPTY_ROLES;
                            } else if (rolesAllowed != null) {
                                localRoles = rolesAllowed.value().asStringArray();
                            }
                            newConstraints.add(this.createSecurityConstraint(webXml, this.getUriPath(subpath, fullAppPath.toString()), localRoles));
                            iterator.remove();
                        }
                        if (resourceMethods.isEmpty()) break block16;
                        classRolesAllowed = classInfo.classAnnotations().stream().filter(a -> a.name().equals((Object)ROLES_ALLOWED)).findFirst().orElse(null);
                        classDenyAll = classInfo.classAnnotations().stream().filter(a -> a.name().equals((Object)DENY_ALL)).findFirst().orElse(null);
                        classPermitAll = classInfo.classAnnotations().stream().filter(a -> a.name().equals((Object)PERMIT_ALL)).findFirst().orElse(null);
                        if (!newConstraints.isEmpty()) break block17;
                        uriPath = fullAppPath.toString() + "*";
                        if (classDenyAll == null) break block18;
                        newConstraints.add(this.createSecurityConstraint(webXml, uriPath, null));
                        break block16;
                    }
                    if (classPermitAll == null) break block19;
                    newConstraints.add(this.createSecurityConstraint(webXml, uriPath, EMPTY_ROLES));
                    break block16;
                }
                if (classRolesAllowed == null) break block16;
                newConstraints.add(this.createSecurityConstraint(webXml, uriPath, classRolesAllowed.value().asStringArray()));
                break block16;
            }
            for (MethodInfo nonConstrained : resourceMethods) {
                AnnotationInstance path = nonConstrained.annotation(PATH);
                String subpath = path != null ? path.value().asString() : "";
                localRoles = null;
                if (classPermitAll != null) {
                    localRoles = EMPTY_ROLES;
                } else if (classRolesAllowed != null) {
                    localRoles = classRolesAllowed.value().asStringArray();
                }
                if (localRoles == null && (localRoles != null || classDenyAll == null && !this.fraction.isDefaultMissingMethodPermissionsDenyAccess())) continue;
                newConstraints.add(this.createSecurityConstraint(webXml, this.getUriPath(subpath, fullAppPath.toString()), localRoles));
            }
        }
        if (log.isDebugEnabled()) {
            log.debugf("SecurityConstraints introduced by class: %s", (Object)classInfo.name());
            for (SecurityConstraint sc : newConstraints) {
                log.debugf("SecurityConstraint(%s), roles=%s, isPermitAll=%s", (Object)sc.urlPattern(), (Object)sc.roles(), (Object)sc.isPermitAll());
            }
        }
        scannedClasses.add(classInfo.name());
    }

    private SecurityConstraint createSecurityConstraint(WebXmlAsset webXml, String uriPath, String[] localRoles) {
        SecurityConstraint securityConstraint = webXml.protect(uriPath);
        if (localRoles == null) {
            securityConstraint.withRole("");
        } else if (localRoles.length == 0) {
            securityConstraint.permitAll();
        } else {
            securityConstraint.withRole(localRoles);
        }
        return securityConstraint;
    }

    private String getUriPath(String subpath, String fullAppPath) {
        String uriPath = subpath.isEmpty() ? fullAppPath.substring(0, fullAppPath.length() - 1) : (subpath.charAt(0) == '/' ? fullAppPath + subpath.substring(1) : fullAppPath + subpath);
        int pathParamStart = uriPath.indexOf(123);
        if (pathParamStart >= 0) {
            if ((uriPath = uriPath.substring(0, pathParamStart)).charAt(uriPath.length() - 1) != '/') {
                uriPath = uriPath + '/';
            }
            uriPath = uriPath + "*";
        }
        return uriPath;
    }

    private List<MethodInfo> getResourceMethods(ClassInfo classInfo, Iterable<DotName> httpMethods) {
        ArrayList<MethodInfo> resourceMethods = new ArrayList<MethodInfo>();
        for (MethodInfo method : classInfo.methods()) {
            if (!this.isResourceMethod(method, httpMethods)) continue;
            resourceMethods.add(method);
        }
        return resourceMethods;
    }

    private boolean isResourceMethod(MethodInfo method, Iterable<DotName> httpMethods) {
        for (DotName httpMethod : httpMethods) {
            if (!method.hasAnnotation(httpMethod)) continue;
            return true;
        }
        return false;
    }

    private Iterable<DotName> collectHttpMethods() {
        ArrayList<DotName> httpMethods = new ArrayList<DotName>();
        httpMethods.add(GET);
        httpMethods.add(POST);
        httpMethods.add(PUT);
        httpMethods.add(DELETE);
        httpMethods.add(HEAD);
        httpMethods.add(OPTIONS);
        for (AnnotationInstance customHttpMethod : this.index.getAnnotations(HTTP_METHOD)) {
            httpMethods.add(customHttpMethod.name());
        }
        return httpMethods;
    }
}

