package org.jboss.as.appclient.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import java.lang.RuntimeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.io.File;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-23T22:22:43-0500")
public class AppClientLogger_$logger extends DelegatingBasicLogger implements AppClientLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AppClientLogger_$logger.class.getName();
    public AppClientLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void exceptionRunningAppClient(final Throwable cause, final String exceptionName) {
        super.log.logf(FQCN, ERROR, cause, exceptionRunningAppClient$str(), exceptionName);
    }
    private static final String exceptionRunningAppClient = "WFLYAC0002: %s running app client main";
    protected String exceptionRunningAppClient$str() {
        return exceptionRunningAppClient;
    }
    private static final String argAppClientConfig = "Name of the app client configuration file to use (default is \"appclient.xml\")";
    protected String argAppClientConfig$str() {
        return argAppClientConfig;
    }
    @Override
    public final String argAppClientConfig() {
        return String.format(getLoggingLocale(), argAppClientConfig$str());
    }
    private static final String argHelp = "Display this message and exit";
    protected String argHelp$str() {
        return argHelp;
    }
    @Override
    public final String argHelp() {
        return String.format(getLoggingLocale(), argHelp$str());
    }
    private static final String argHost = "Set the url of the application server instance to connect to";
    protected String argHost$str() {
        return argHost;
    }
    @Override
    public final String argHost() {
        return String.format(getLoggingLocale(), argHost$str());
    }
    private static final String argConnectionProperties = "Load ejb-client.properties file from the given url";
    protected String argConnectionProperties$str() {
        return argConnectionProperties;
    }
    @Override
    public final String argConnectionProperties() {
        return String.format(getLoggingLocale(), argConnectionProperties$str());
    }
    private static final String argProperties = "Load system properties from the given url";
    protected String argProperties$str() {
        return argProperties;
    }
    @Override
    public final String argProperties() {
        return String.format(getLoggingLocale(), argProperties$str());
    }
    private static final String argSystemProperty = "Set a system property";
    protected String argSystemProperty$str() {
        return argSystemProperty;
    }
    @Override
    public final String argSystemProperty() {
        return String.format(getLoggingLocale(), argSystemProperty$str());
    }
    private static final String argVersion = "Print version and exit";
    protected String argVersion$str() {
        return argVersion;
    }
    @Override
    public final String argVersion() {
        return String.format(getLoggingLocale(), argVersion$str());
    }
    private static final String argSecMgr = "Runs the container with the security manager enabled.";
    protected String argSecMgr$str() {
        return argSecMgr;
    }
    @Override
    public final String argSecMgr() {
        return String.format(getLoggingLocale(), argSecMgr$str());
    }
    private static final String usageDescription = "The appclient script starts an application client which can be used to test and access the deployed EJBs.";
    protected String usageDescription$str() {
        return usageDescription;
    }
    @Override
    public final String usageDescription() {
        return String.format(getLoggingLocale(), usageDescription$str());
    }
    private static final String appClientNotSpecified = "WFLYAC0004: You must specify the application client to execute";
    protected String appClientNotSpecified$str() {
        return appClientNotSpecified;
    }
    @Override
    public final String appClientNotSpecified() {
        return String.format(getLoggingLocale(), appClientNotSpecified$str());
    }
    private static final String argumentExpected = "WFLYAC0005: Argument expected for option %s";
    protected String argumentExpected$str() {
        return argumentExpected;
    }
    @Override
    public final String argumentExpected(final String arg) {
        return String.format(getLoggingLocale(), argumentExpected$str(), arg);
    }
    private static final String cannotFindAppClient0 = "WFLYAC0006: Could not find application client jar in deployment";
    protected String cannotFindAppClient0$str() {
        return cannotFindAppClient0;
    }
    @Override
    public final RuntimeException cannotFindAppClient() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotFindAppClient0$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindAppClient1 = "WFLYAC0007: Could not find application client %s";
    protected String cannotFindAppClient1$str() {
        return cannotFindAppClient1;
    }
    @Override
    public final DeploymentUnitProcessingException cannotFindAppClient(final String deploymentName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotFindAppClient1$str(), deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadAppClientMainClass = "WFLYAC0008: Could not load application client main class";
    protected String cannotLoadAppClientMainClass$str() {
        return cannotLoadAppClientMainClass;
    }
    @Override
    public final RuntimeException cannotLoadAppClientMainClass(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotLoadAppClientMainClass$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadProperties = "WFLYAC0010: Unable to load properties from URL %s";
    protected String cannotLoadProperties$str() {
        return cannotLoadProperties;
    }
    @Override
    public final String cannotLoadProperties(final URL url) {
        return String.format(getLoggingLocale(), cannotLoadProperties$str(), url);
    }
    private static final String cannotStartAppClient1 = "WFLYAC0011: Could not start app client %s as no main class was found";
    protected String cannotStartAppClient1$str() {
        return cannotStartAppClient1;
    }
    @Override
    public final RuntimeException cannotStartAppClient(final String deploymentName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotStartAppClient1$str(), deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStartAppClient2 = "WFLYAC0012: Could not start app client %s as no main method was found on main class %s";
    protected String cannotStartAppClient2$str() {
        return cannotStartAppClient2;
    }
    @Override
    public final RuntimeException cannotStartAppClient(final String deploymentName, final Class<?> mainClass) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotStartAppClient2$str(), deploymentName, mainClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateSubsystemDeclaration = "WFLYAC0013: Duplicate subsystem declaration";
    protected String duplicateSubsystemDeclaration$str() {
        return duplicateSubsystemDeclaration;
    }
    @Override
    public final XMLStreamException duplicateSubsystemDeclaration(final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), duplicateSubsystemDeclaration$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseXml1 = "WFLYAC0015: Failed to parse %s";
    protected String failedToParseXml1$str() {
        return failedToParseXml1;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParseXml(final Throwable cause, final VirtualFile appXml) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParseXml1$str(), appXml), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseXml3 = "WFLYAC0016: Failed to parse %s at [%d,%d]";
    protected String failedToParseXml3$str() {
        return failedToParseXml3;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParseXml(final Throwable cause, final VirtualFile appXml, final int lineNumber, final int columnNumber) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParseXml3$str(), appXml, lineNumber, columnNumber), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String malformedUrl = "WFLYAC0017: Malformed URL provided for option %s";
    protected String malformedUrl$str() {
        return malformedUrl;
    }
    @Override
    public final String malformedUrl(final String arg) {
        return String.format(getLoggingLocale(), malformedUrl$str(), arg);
    }
    private static final String multipleAppClientsFound = "WFLYAC0018: More than one application client found and no app client name specified";
    protected String multipleAppClientsFound$str() {
        return multipleAppClientsFound;
    }
    @Override
    public final RuntimeException multipleAppClientsFound() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), multipleAppClientsFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownOption = "WFLYAC0020: Unknown option %s";
    protected String unknownOption$str() {
        return unknownOption;
    }
    @Override
    public final String unknownOption(final String option) {
        return String.format(getLoggingLocale(), unknownOption$str(), option);
    }
    private static final String couldNotLoadCallbackClass = "WFLYAC0021: Could not load callback-handler class %s";
    protected String couldNotLoadCallbackClass$str() {
        return couldNotLoadCallbackClass;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotLoadCallbackClass(final String clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotLoadCallbackClass$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateCallbackHandler = "WFLYAC0022: Could not create instance of callback-handler class %s";
    protected String couldNotCreateCallbackHandler$str() {
        return couldNotCreateCallbackHandler;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotCreateCallbackHandler(final String clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotCreateCallbackHandler$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindAppClientFile = "WFLYAC0023: Could find application client %s";
    protected String cannotFindAppClientFile$str() {
        return cannotFindAppClientFile;
    }
    @Override
    public final RuntimeException cannotFindAppClientFile(final File deploymentName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotFindAppClientFile$str(), deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSpecifyBothHostAndPropertiesFile = "WFLYAC0024: Cannot specify both a host to connect to and an ejb-client.properties file. ";
    protected String cannotSpecifyBothHostAndPropertiesFile$str() {
        return cannotSpecifyBothHostAndPropertiesFile;
    }
    @Override
    public final RuntimeException cannotSpecifyBothHostAndPropertiesFile() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotSpecifyBothHostAndPropertiesFile$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
