/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.util.ArrayList;
import org.jboss.as.appclient.deployment.AppClientAttachments;
import org.jboss.as.appclient.logging.AppClientMessages;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class ActiveApplicationClientProcessor
implements DeploymentUnitProcessor {
    private final String deploymentName;

    public ActiveApplicationClientProcessor(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            if (deploymentUnit.getParent() == null) {
                deploymentUnit.putAttachment(AppClientAttachments.START_APP_CLIENT, (Object)true);
            }
            return;
        }
        ArrayList<DeploymentUnit> appClients = new ArrayList<DeploymentUnit>();
        for (DeploymentUnit subDeployment : deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
            if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)subDeployment)) continue;
            if (this.deploymentName != null && this.deploymentName.equals(subDeployment.getName())) {
                subDeployment.putAttachment(AppClientAttachments.START_APP_CLIENT, (Object)true);
                return;
            }
            appClients.add(subDeployment);
        }
        if (this.deploymentName != null && !this.deploymentName.isEmpty()) {
            throw AppClientMessages.MESSAGES.cannotFindAppClient(this.deploymentName);
        }
        if (appClients.size() != 1) {
            if (appClients.isEmpty()) {
                throw AppClientMessages.MESSAGES.cannotFindAppClient();
            }
            throw AppClientMessages.MESSAGES.multipleAppClientsFound();
        }
        ((DeploymentUnit)appClients.get(0)).putAttachment(AppClientAttachments.START_APP_CLIENT, (Object)true);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

