/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;

public final class CachedIdentity
implements Serializable {
    private static final long serialVersionUID = -6408689383511392746L;
    private final String mechanismName;
    private final boolean programmatic;
    private final String name;
    private final transient SecurityIdentity securityIdentity;
    private final Set<String> roles;

    public CachedIdentity(String mechanismName, boolean programmatic, SecurityIdentity securityIdentity) {
        this(mechanismName, programmatic, Assert.checkNotNullParam("securityIdentity", securityIdentity), securityIdentity.getPrincipal());
    }

    public CachedIdentity(String mechanismName, boolean programmatic, Principal principal) {
        this(mechanismName, programmatic, null, principal);
    }

    public CachedIdentity(String mechanismName, boolean programmatic, Principal principal, Set<String> roles) {
        this(mechanismName, programmatic, null, principal, roles);
    }

    private CachedIdentity(String mechanismName, boolean programmatic, SecurityIdentity securityIdentity, Principal principal) {
        this.mechanismName = Assert.checkNotNullParam("mechanismName", mechanismName);
        this.programmatic = programmatic;
        this.name = Assert.checkNotNullParam("name", Assert.checkNotNullParam("principal", principal).getName());
        this.securityIdentity = securityIdentity;
        this.roles = securityIdentity != null && securityIdentity.getPrincipal() != null ? Roles.toSet(securityIdentity.getRoles()) : Collections.emptySet();
    }

    private CachedIdentity(String mechanismName, boolean programmatic, SecurityIdentity securityIdentity, Principal principal, Set<String> roles) {
        this.mechanismName = Assert.checkNotNullParam("mechanismName", mechanismName);
        this.programmatic = programmatic;
        this.name = Assert.checkNotNullParam("name", Assert.checkNotNullParam("principal", principal).getName());
        this.securityIdentity = securityIdentity;
        this.roles = roles;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getName() {
        return this.name;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public boolean isProgrammatic() {
        return this.programmatic;
    }

    public Set<String> getRoles() {
        if (this.securityIdentity != null) {
            return Roles.toSet(this.securityIdentity.getRoles());
        }
        return this.roles;
    }

    public String toString() {
        return "CachedIdentity{" + this.mechanismName + ", '" + this.name + "', " + this.securityIdentity + ", " + this.programmatic + "}";
    }
}

