/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.AttributeAnalysis;
import org.jboss.as.jacorb.rmi.ContainerAnalysis;
import org.jboss.as.jacorb.rmi.OperationAnalysis;
import org.jboss.as.jacorb.rmi.RMIIIOPViolationException;
import org.jboss.as.jacorb.rmi.RmiIdlUtil;
import org.jboss.as.jacorb.rmi.WorkCacheManager;

public class InterfaceAnalysis
extends ContainerAnalysis {
    private boolean abstractInterface;
    private String[] allTypeIds;
    Map<String, OperationAnalysis> operationAnalysisMap;
    private static WorkCacheManager cache = new WorkCacheManager(InterfaceAnalysis.class);

    public static InterfaceAnalysis getInterfaceAnalysis(Class cls) throws RMIIIOPViolationException {
        return (InterfaceAnalysis)cache.getAnalysis(cls);
    }

    public static void clearCache(ClassLoader classLoader) {
        cache.clearClassLoader(classLoader);
    }

    protected InterfaceAnalysis(Class cls) {
        super(cls);
    }

    @Override
    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        this.calculateOperationAnalysisMap();
        this.fixupCaseNames();
    }

    public boolean isAbstractInterface() {
        return this.abstractInterface;
    }

    public boolean isRmiIdlRemoteInterface() {
        return !this.abstractInterface;
    }

    public String[] getAllTypeIds() {
        return (String[])this.allTypeIds.clone();
    }

    @Override
    protected ArrayList getContainedEntries() {
        int i;
        ArrayList<AbstractAnalysis> ret = new ArrayList<AbstractAnalysis>(this.constants.length + this.attributes.length + this.operations.length);
        for (i = 0; i < this.constants.length; ++i) {
            ret.add(this.constants[i]);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            ret.add(this.attributes[i]);
        }
        for (i = 0; i < this.operations.length; ++i) {
            ret.add(this.operations[i]);
        }
        return ret;
    }

    @Override
    protected void analyzeOperations() throws RMIIIOPViolationException {
        int i;
        if (!this.cls.isInterface()) {
            throw JacORBMessages.MESSAGES.notAnInterface(this.cls.getName());
        }
        this.abstractInterface = RmiIdlUtil.isAbstractInterface(this.cls);
        this.calculateAllTypeIds();
        int operationCount = 0;
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 0xE) != 0) continue;
            ++operationCount;
        }
        this.operations = new OperationAnalysis[operationCount];
        operationCount = 0;
        for (i = 0; i < this.methods.length; ++i) {
            if ((this.m_flags[i] & 0xE) != 0) continue;
            this.operations[operationCount] = new OperationAnalysis(this.methods[i]);
            ++operationCount;
        }
    }

    protected void calculateOperationAnalysisMap() {
        OperationAnalysis oa;
        int i;
        this.operationAnalysisMap = new HashMap<String, OperationAnalysis>();
        for (i = 0; i < this.operations.length; ++i) {
            oa = this.operations[i];
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            AttributeAnalysis attr = this.attributes[i];
            oa = attr.getAccessorAnalysis();
            if (oa == null) continue;
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
            oa = attr.getMutatorAnalysis();
            if (oa == null) continue;
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
        }
    }

    protected void calculateAllTypeIds() {
        if (!this.isRmiIdlRemoteInterface()) {
            this.allTypeIds = new String[0];
        } else {
            int i;
            ArrayList<String> a = new ArrayList<String>();
            InterfaceAnalysis[] intfs = this.getInterfaces();
            for (i = 0; i < intfs.length; ++i) {
                String[] ss = intfs[i].getAllTypeIds();
                for (int j = 0; j < ss.length; ++j) {
                    if (a.contains(ss[j])) continue;
                    a.add(ss[j]);
                }
            }
            this.allTypeIds = new String[a.size() + 1];
            this.allTypeIds[0] = this.getRepositoryId();
            for (i = 1; i <= a.size(); ++i) {
                this.allTypeIds[i] = (String)a.get(a.size() - i);
            }
        }
    }
}

