/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.mail.MailSessionDefinition;
import javax.mail.MailSessionDefinitions;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.mail.extension.DirectMailSessionInjectionSource;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.mail.extension.SessionProviderFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.MailSessionMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class MailSessionDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName MAIL_SESSION_DEFINITION = DotName.createSimple((String)MailSessionDefinition.class.getName());
    private static final DotName MAIL_SESSION_DEFINITIONS = DotName.createSimple((String)MailSessionDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List datasources;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List datasourceDefinitions = index.getAnnotations(MAIL_SESSION_DEFINITIONS);
        if (datasourceDefinitions != null) {
            for (AnnotationInstance annotation : datasourceDefinitions) {
                AnnotationTarget target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeMessages.MESSAGES.classOnlyAnnotation("@MailSessionDefinitions", target);
                }
                List<AnnotationInstance> datasources2 = this.getNestedMailSessionAnnotations(annotation);
                for (AnnotationInstance datasource : datasources2) {
                    this.processDataSourceDefinition(eeModuleDescription, datasource, (ClassInfo)target, applicationClasses);
                }
            }
        }
        if ((datasources = index.getAnnotations(MAIL_SESSION_DEFINITION)) != null) {
            for (AnnotationInstance datasource : datasources) {
                AnnotationTarget target = datasource.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeMessages.MESSAGES.classOnlyAnnotation("@MailSessionDefinition", target);
                }
                this.processDataSourceDefinition(eeModuleDescription, datasource, (ClassInfo)target, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processDataSourceDefinition(EEModuleDescription eeModuleDescription, AnnotationInstance datasourceDefinition, ClassInfo targetClass, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        BindingConfiguration bindingConfiguration = this.getBindingConfiguration(datasourceDefinition);
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(targetClass.name().toString());
        classDescription.getBindingConfigurations().add(bindingConfiguration);
    }

    private BindingConfiguration getBindingConfiguration(AnnotationInstance annotationInstance) {
        AnnotationValue nameValue = annotationInstance.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw EeMessages.MESSAGES.annotationAttributeMissing("@MailSessionDefinition", "name");
        }
        MailSessionMetaData metaData = new MailSessionMetaData();
        metaData.setTransportProtocol(this.asString(annotationInstance, "transportProtocol"));
        metaData.setStoreProtocol(this.asString(annotationInstance, "storeProtocol"));
        metaData.setHost(this.asString(annotationInstance, "host"));
        metaData.setUser(this.asString(annotationInstance, "user"));
        metaData.setPassword(this.asString(annotationInstance, "password"));
        metaData.setFrom(this.asString(annotationInstance, "from"));
        metaData.setName(nameValue.asString());
        String jndiName = MailSessionAdd.getJndiName(nameValue.asString());
        for (String fullProp : this.asArray(annotationInstance, "properties")) {
            PropertyMetaData p = new PropertyMetaData();
            String[] prop = fullProp.split("\\\\=");
            p.setName(prop[0]);
            p.setValue(prop[1]);
            metaData.getProperties().add((MappableMetaData)p);
        }
        SessionProvider provider = SessionProviderFactory.create(metaData);
        DirectMailSessionInjectionSource source = new DirectMailSessionInjectionSource(jndiName, provider);
        return new BindingConfiguration(jndiName, (InjectionSource)source);
    }

    private String asString(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : (value.asString().isEmpty() ? null : value.asString());
    }

    private String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? new String[]{} : value.asStringArray();
    }

    private List<AnnotationInstance> getNestedMailSessionAnnotations(AnnotationInstance mailSessionDefinitions) {
        if (mailSessionDefinitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = mailSessionDefinitions.value().asNestedArray();
        return Arrays.asList(nested);
    }
}

