/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.security.auth.callback.JASPICallbackHandler;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;
import org.wildfly.extension.undertow.security.jaspi.JASPIAuthenticationMechanism;
import org.wildfly.extension.undertow.security.jaspi.JASPICAttachment;
import org.wildfly.extension.undertow.security.jaspi.JASPICSecurityContext;
import org.xnio.conduits.StreamSinkConduit;

public class JASPICInitialHandler
implements HttpHandler {
    private static final String JASPI_HTTP_SERVLET_LAYER = "HttpServlet";
    private static final AttachmentKey<Boolean> ALREADY_WRAPPED = AttachmentKey.create(Boolean.class);
    private final String securityDomain;
    private final HttpHandler next;

    public JASPICInitialHandler(String securityDomain, HttpHandler next) {
        this.securityDomain = securityDomain;
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AuthenticatedSessionManager.AuthenticatedSession authSession;
        ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        JASPIServerAuthenticationManager sam = this.createJASPIAuthenticationManager();
        GenericMessageInfo messageInfo = this.createMessageInfo(exchange, exchange.getSecurityContext());
        String applicationIdentifier = this.buildApplicationIdentifier(requestContext);
        JASPICallbackHandler cbh = new JASPICallbackHandler();
        UndertowLogger.ROOT_LOGGER.debugf("validateRequest for layer [%s] and applicationContextIdentifier [%s]", JASPI_HTTP_SERVLET_LAYER, applicationIdentifier);
        Account cachedAccount = null;
        JASPICSecurityContext jaspicSecurityContext = (JASPICSecurityContext)exchange.getSecurityContext();
        AuthenticatedSessionManager sessionManager = (AuthenticatedSessionManager)exchange.getAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY);
        if (sessionManager != null && (authSession = sessionManager.lookupSession(exchange)) != null && (cachedAccount = authSession.getAccount()) != null) {
            jaspicSecurityContext.setCachedAuthenticatedAccount(cachedAccount);
        }
        boolean isValid = sam.isValid((MessageInfo)messageInfo, new Subject(), JASPI_HTTP_SERVLET_LAYER, applicationIdentifier, (CallbackHandler)cbh);
        jaspicSecurityContext.setCachedAuthenticatedAccount(null);
        exchange.putAttachment(JASPICAttachment.ATTACHMENT_KEY, (Object)new JASPICAttachment(isValid, requestContext, sam, messageInfo, applicationIdentifier, cbh, cachedAccount));
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletRequest((ServletRequest)((HttpServletRequest)messageInfo.getRequestMessage()));
        servletRequestContext.setServletResponse((ServletResponse)((HttpServletResponse)messageInfo.getResponseMessage()));
        this.secureResponse(exchange, sam, messageInfo, cbh);
        this.next.handleRequest(exchange);
    }

    private JASPIServerAuthenticationManager createJASPIAuthenticationManager() {
        return new JASPIServerAuthenticationManager(this.securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    private void secureResponse(HttpServerExchange exchange, final JASPIServerAuthenticationManager sam, final GenericMessageInfo messageInfo, final JASPICallbackHandler cbh) {
        if (exchange.getAttachment(ALREADY_WRAPPED) != null || exchange.isResponseStarted()) {
            return;
        }
        exchange.putAttachment(ALREADY_WRAPPED, (Object)true);
        exchange.addResponseWrapper((ConduitWrapper)new ConduitWrapper<StreamSinkConduit>(){

            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                String applicationIdentifier = JASPICInitialHandler.this.buildApplicationIdentifier(requestContext);
                if (!JASPICInitialHandler.this.wasAuthExceptionThrown(exchange)) {
                    UndertowLogger.ROOT_LOGGER.debugf("secureResponse for layer [%s] and applicationContextIdentifier [%s].", JASPICInitialHandler.JASPI_HTTP_SERVLET_LAYER, applicationIdentifier);
                    sam.secureResponse((MessageInfo)messageInfo, new Subject(), JASPICInitialHandler.JASPI_HTTP_SERVLET_LAYER, applicationIdentifier, (CallbackHandler)cbh);
                    ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    servletRequestContext.setServletRequest((ServletRequest)((HttpServletRequest)messageInfo.getRequestMessage()));
                    servletRequestContext.setServletResponse((ServletResponse)((HttpServletResponse)messageInfo.getResponseMessage()));
                }
                return (StreamSinkConduit)factory.create();
            }
        });
    }

    private boolean wasAuthExceptionThrown(HttpServerExchange exchange) {
        return ((org.jboss.security.SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT)).getData().get(AuthException.class.getName()) != null;
    }

    private String buildApplicationIdentifier(ServletRequestContext attachment) {
        ServletRequest servletRequest = attachment.getServletRequest();
        return servletRequest.getServletContext().getVirtualServerName() + " " + servletRequest.getServletContext().getContextPath();
    }

    private GenericMessageInfo createMessageInfo(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)servletRequestContext.getServletRequest());
        messageInfo.setResponseMessage((Object)servletRequestContext.getServletResponse());
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", this.isMandatory(servletRequestContext).toString());
        messageInfo.getMap().put(JASPIAuthenticationMechanism.SECURITY_CONTEXT_ATTACHMENT_KEY, securityContext);
        messageInfo.getMap().put(JASPIAuthenticationMechanism.HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY, exchange);
        return messageInfo;
    }

    private Boolean isMandatory(ServletRequestContext attachment) {
        return attachment.getExchange().getSecurityContext() != null && attachment.getExchange().getSecurityContext().isAuthenticationRequired();
    }
}

