/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.web.host.WebHost;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.undertow.ConsoleRedirectService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HostDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebHostService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;

class HostAdd
extends AbstractAddStepHandler {
    static final HostAdd INSTANCE = new HostAdd();

    private HostAdd() {
        super(new AttributeDefinition[]{HostDefinition.ALIAS, HostDefinition.DEFAULT_WEB_MODULE, HostDefinition.DEFAULT_RESPONSE_CODE, HostDefinition.DISABLE_CONSOLE_REDIRECT, HostDefinition.QUEUE_REQUESTS_ON_START});
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String ourCap = HostDefinition.HOST_CAPABILITY.getDynamicName(context.getCurrentAddress());
        String serverCap = ServerDefinition.SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress().getParent());
        context.registerAdditionalCapabilityRequirement(serverCap, ourCap, null);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress serverAddress = address.getParent();
        PathAddress subsystemAddress = serverAddress.getParent();
        ModelNode subsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(subsystemAddress, false), (int)0);
        ModelNode serverModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(serverAddress, false), (int)0);
        String name = address.getLastElement().getValue();
        List aliases = HostDefinition.ALIAS.unwrap((ExpressionResolver)context, model);
        String defaultWebModule = HostDefinition.DEFAULT_WEB_MODULE.resolveModelAttribute(context, model).asString();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, subsystemModel).asString();
        String defaultHostName = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, serverModel).asString();
        String serverName = serverAddress.getLastElement().getValue();
        boolean isDefaultHost = defaultServerName.equals(serverName) && name.equals(defaultHostName);
        int defaultResponseCode = HostDefinition.DEFAULT_RESPONSE_CODE.resolveModelAttribute(context, model).asInt();
        boolean enableConsoleRedirect = !HostDefinition.DISABLE_CONSOLE_REDIRECT.resolveModelAttribute(context, model).asBoolean();
        Boolean queueRequestsOnStart = null;
        if (model.hasDefined(HostDefinition.QUEUE_REQUESTS_ON_START.getName())) {
            queueRequestsOnStart = HostDefinition.QUEUE_REQUESTS_ON_START.resolveModelAttribute(context, model).asBoolean();
        }
        if (!defaultWebModule.equals("ROOT.war") || DefaultDeploymentMappingProvider.instance().getMapping("ROOT.war") == null) {
            DefaultDeploymentMappingProvider.instance().addMapping(defaultWebModule, serverName, name);
        }
        ServiceName virtualHostServiceName = HostDefinition.HOST_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
        Host service = new Host(name, aliases == null ? new LinkedList() : aliases, defaultWebModule, defaultResponseCode, queueRequestsOnStart);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(HostDefinition.HOST_CAPABILITY).setInstance((Service)service).addCapabilityRequirement("org.wildfly.undertow.server", Server.class, service.getServerInjection(), new String[]{serverName}).addCapabilityRequirement("org.wildfly.undertow", UndertowService.class, service.getUndertowService()).addDependency(context.getCapabilityServiceName("org.wildfly.server.suspend-controller", SuspendController.class), SuspendController.class, service.getSuspendControllerInjectedValue()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.getControlledProcessStateServiceInjectedValue());
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (isDefaultHost) {
            this.addCommonHost(context, aliases, serverName, virtualHostServiceName);
            builder.addAliases(new ServiceName[]{UndertowService.DEFAULT_HOST});
        }
        builder.addAliases(new ServiceName[]{UndertowService.virtualHostName(serverName, name)});
        builder.install();
        if (enableConsoleRedirect) {
            ServiceName consoleRedirectName = UndertowService.consoleRedirectServiceName(serverName, name);
            if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
                ConsoleRedirectService redirectService = new ConsoleRedirectService();
                ServiceBuilder redirectBuilder = context.getServiceTarget().addService(consoleRedirectName, (org.jboss.msc.service.Service)redirectService).addDependency(UndertowHttpManagementService.SERVICE_NAME, HttpManagement.class, redirectService.getHttpManagementInjector()).addDependency(virtualHostServiceName, Host.class, redirectService.getHostInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
                redirectBuilder.install();
            } else {
                ConsoleRedirectService redirectService = new ConsoleRedirectService();
                ServiceBuilder redirectBuilder = context.getServiceTarget().addService(consoleRedirectName, (org.jboss.msc.service.Service)redirectService).addDependency(virtualHostServiceName, Host.class, redirectService.getHostInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
                redirectBuilder.install();
            }
        }
    }

    private void addCommonHost(OperationContext context, List<String> aliases, String serverName, ServiceName virtualHostServiceName) {
        WebHostService service = new WebHostService();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(WebHost.CAPABILITY).setInstance((Service)service).addCapabilityRequirement("org.wildfly.undertow.server", Server.class, service.getServer(), new String[]{serverName}).addCapabilityRequirement("org.wildfly.web.common.server", CommonWebServer.class).addDependency(virtualHostServiceName, Host.class, service.getHost());
        if (context.hasOptionalCapability("org.wildfly.request-controller", null, null)) {
            builder.addCapabilityRequirement("org.wildfly.request-controller", RequestController.class, service.getRequestControllerInjectedValue());
        }
        builder.addAliases(new ServiceName[]{WebHost.SERVICE_NAME.append(new String[]{context.getCurrentAddressValue()})});
        if (aliases != null) {
            for (String alias : aliases) {
                builder.addAliases(new ServiceName[]{WebHost.SERVICE_NAME.append(new String[]{alias})});
            }
        }
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        builder.install();
    }
}

