/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.beans.FeatureDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELClass;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ImportHandler;
import org.wildfly.common.Assert;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ImportedClassELResolver
extends ELResolver {
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static final Object NULL_MARKER = new Object();

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null) {
            return null;
        }
        if (!(property instanceof String)) {
            return null;
        }
        final ImportHandler importHandler = context.getImportHandler();
        if (importHandler == null) {
            return null;
        }
        final String klassName = (String)property;
        Object cacheResult = this.cache.get(klassName);
        if (cacheResult != null) {
            if (cacheResult == NULL_MARKER) {
                return null;
            }
            context.setPropertyResolved(true);
            return new ELClass((Class)cacheResult);
        }
        Class klass = WildFlySecurityManager.isChecking() ? (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                return importHandler.resolveClass(klassName);
            }
        }) : importHandler.resolveClass(klassName);
        if (klass != null) {
            this.cache.put(klassName, klass);
            context.setPropertyResolved(true);
            return new ELClass(klass);
        }
        this.cache.put(klassName, NULL_MARKER);
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context, UndertowLogger.ROOT_LOGGER.nullNotAllowed("ELContext"));
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Assert.checkNotNullParamWithNullPointerException((String)"context", (Object)context);
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }
}

