/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.jacc.PolicyConfiguration;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagFileInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.jasper.deploy.TagVariableInfo;
import org.jboss.annotation.javaee.Icon;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ee.security.JaccService;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.web.common.AdvancedSecurityMetaData;
import org.jboss.as.web.common.CachingWebInjectionContainer;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.SimpleWebInjectionContainer;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.requestcontroller.ControlPointService;
import org.wildfly.extension.requestcontroller.RequestControllerActivationMarker;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.HostSingleSignOnDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.ComponentStartupCountdownHandler;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.deployment.UndertowHandlersDeploymentProcessor;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.jacc.WarJACCDeployer;
import org.wildfly.extension.undertow.session.NonDistributableSessionManagementProvider;
import org.wildfly.extension.undertow.session.SessionManagementProviderFactory;

public class UndertowDeploymentProcessor
implements DeploymentUnitProcessor,
Function<SessionManagerFactoryConfiguration, SessionManagerFactory> {
    public static final String OLD_URI_PREFIX = "http://java.sun.com";
    public static final String NEW_URI_PREFIX = "http://xmlns.jcp.org";
    private static final String LEGACY_JACC_CAPABILITY_NAME = "org.wildfly.legacy-security.jacc";
    private static final String ELYTRON_JACC_CAPABILITY_NAME = "org.wildfly.security.jacc-policy";
    private final String defaultServer;
    private final String defaultHost;
    private final String defaultContainer;
    private final Predicate<String> mappedSecurityDomain;
    private final DefaultDeploymentMappingProvider defaultModuleMappingProvider;
    private final SessionManagementProviderFactory sessionManagementProviderFactory;
    private final SessionManagementProvider nonDistributableSessionManagementProvider;

    public UndertowDeploymentProcessor(String defaultHost, String defaultContainer, String defaultServer, Predicate<String> mappedSecurityDomain) {
        this.defaultHost = defaultHost;
        this.defaultModuleMappingProvider = DefaultDeploymentMappingProvider.instance();
        if (defaultHost == null) {
            throw UndertowLogger.ROOT_LOGGER.nullDefaultHost();
        }
        this.defaultContainer = defaultContainer;
        this.defaultServer = defaultServer;
        this.mappedSecurityDomain = mappedSecurityDomain;
        Iterator<SessionManagementProviderFactory> factories = ServiceLoader.load(SessionManagementProviderFactory.class, SessionManagementProviderFactory.class.getClassLoader()).iterator();
        this.sessionManagementProviderFactory = factories.hasNext() ? factories.next() : null;
        this.nonDistributableSessionManagementProvider = new NonDistributableSessionManagementProvider(this);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String defaultHostForDeployment;
        String defaultServerForDeployment;
        WarMetaData warMetaData;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit) && deploymentUnit.getParent() == null) {
            ControlPointService.install((ServiceTarget)phaseContext.getServiceTarget(), (String)deploymentUnit.getName(), (String)"undertow");
        }
        if ((warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)) == null) {
            return;
        }
        String deploymentName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "." + deploymentUnit.getName();
        Map.Entry<String, String> serverHost = this.defaultModuleMappingProvider.getMapping(deploymentName);
        if (serverHost != null) {
            defaultServerForDeployment = serverHost.getKey();
            defaultHostForDeployment = serverHost.getValue();
        } else {
            defaultServerForDeployment = this.defaultServer;
            defaultHostForDeployment = this.defaultHost;
        }
        String serverInstanceName = warMetaData.getMergedJBossWebMetaData().getServerInstanceName() == null ? defaultServerForDeployment : warMetaData.getMergedJBossWebMetaData().getServerInstanceName();
        String hostName = this.hostNameOfDeployment(warMetaData, defaultHostForDeployment);
        boolean isDefaultWebModule = serverHost != null && serverInstanceName.equals(defaultServerForDeployment) && hostName.equals(defaultHostForDeployment);
        this.processDeployment(warMetaData, deploymentUnit, phaseContext.getServiceTarget(), deploymentName, hostName, serverInstanceName, isDefaultWebModule);
    }

    private String hostNameOfDeployment(WarMetaData metaData, String defaultHost) {
        String hostName;
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw UndertowLogger.ROOT_LOGGER.nullHostName();
        }
        return hostName;
    }

    private void processDeployment(WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, final String deploymentName, String hostName, final String serverInstanceName, boolean isDefaultWebModule) throws DeploymentUnitProcessingException {
        WarJACCDeployer deployer;
        JaccService jaccService;
        boolean legacyJacc;
        Supplier sicSupplier;
        Supplier smfSupplier;
        SharedSessionManagerConfig sharedSessionManagerConfig;
        ResourceRoot deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentRoot = deploymentResourceRoot.getRoot();
        final Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException((Throwable)UndertowLogger.ROOT_LOGGER.failedToResolveModule(deploymentUnit));
        }
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        List setupActions = deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS);
        CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ScisMetaData scisMetaData = (ScisMetaData)deploymentUnit.getAttachment(ScisMetaData.ATTACHMENT_KEY);
        HashSet<ServiceName> dependentComponents = new HashSet<ServiceName>();
        List components = deploymentUnit.getAttachmentList(WebComponentDescription.WEB_COMPONENTS);
        Set failed = (Set)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.FAILED_COMPONENTS);
        for (ServiceName component : components) {
            if (failed.contains(component)) continue;
            dependentComponents.add(component);
        }
        String servletContainerName = metaData.getServletContainerName();
        if (servletContainerName == null) {
            servletContainerName = this.defaultContainer;
        }
        boolean componentRegistryExists = deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.COMPONENT_REGISTRY) != null;
        final ComponentRegistry componentRegistry = componentRegistryExists ? (ComponentRegistry)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.COMPONENT_REGISTRY) : new ComponentRegistry(null);
        ModuleClassLoader loader = module.getClassLoader();
        CachingWebInjectionContainer injectionContainer = metaData.getDistributable() == null ? new CachingWebInjectionContainer((ClassLoader)loader, componentRegistry) : new SimpleWebInjectionContainer((ClassLoader)loader, componentRegistry);
        String jaccContextId = metaData.getJaccContextID();
        if (jaccContextId == null) {
            jaccContextId = deploymentUnit.getName();
        }
        if (deploymentUnit.getParent() != null) {
            jaccContextId = deploymentUnit.getParent().getName() + "!" + jaccContextId;
        }
        String pathName = UndertowDeploymentProcessor.pathNameOfDeployment(deploymentUnit, metaData, isDefaultWebModule);
        HashSet<ServiceName> additionalDependencies = new HashSet<ServiceName>();
        for (SetupAction setupAction : setupActions) {
            Set dependencies = setupAction.dependencies();
            if (dependencies == null) continue;
            additionalDependencies.addAll(dependencies);
        }
        SharedSessionManagerConfig sharedSessionManagerConfig2 = sharedSessionManagerConfig = deploymentUnit.getParent() != null ? (SharedSessionManagerConfig)deploymentUnit.getParent().getAttachment(SharedSessionManagerConfig.ATTACHMENT_KEY) : null;
        if (!deploymentResourceRoot.isUsePhysicalCodeSource()) {
            try {
                deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("org.apache.jasper.Constants.CODE_SOURCE_ATTRIBUTE_NAME", (Object)deploymentRoot.toURL()));
            }
            catch (MalformedURLException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        deploymentUnit.addToAttachmentList(ServletContextAttribute.ATTACHMENT_KEY, (Object)new ServletContextAttribute("org.apache.jasper.Constants.PERMISSION_COLLECTION_ATTRIBUTE_NAME", deploymentUnit.getAttachment(Attachments.MODULE_PERMISSIONS)));
        additionalDependencies.addAll(warMetaData.getAdditionalDependencies());
        try {
            String capability = HostSingleSignOnDefinition.HOST_SSO_CAPABILITY.fromBaseCapability(new String[]{serverInstanceName, hostName}).getName();
            capabilitySupport.getCapabilityRuntimeAPI(capability, Object.class);
            additionalDependencies.add(capabilitySupport.getCapabilityServiceName(capability));
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException capability) {
            // empty catch block
        }
        ServiceName hostServiceName = UndertowService.virtualHostName(serverInstanceName, hostName);
        ServiceName legacyDeploymentServiceName = UndertowService.deploymentServiceName(serverInstanceName, hostName, pathName);
        ServiceName deploymentServiceName = UndertowService.deploymentServiceName(deploymentUnit.getServiceName());
        StartupCountdown countDown = (StartupCountdown)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.STARTUP_COUNTDOWN);
        if (countDown != null) {
            deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS, handler -> new ComponentStartupCountdownHandler(handler, countDown));
        }
        String securityDomain = (String)deploymentUnit.getAttachment(UndertowAttachments.RESOLVED_SECURITY_DOMAIN);
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        ServiceName deploymentInfoServiceName = deploymentServiceName.append(UndertowDeploymentInfoService.SERVICE_NAME);
        ServiceName legacyDeploymentInfoServiceName = legacyDeploymentServiceName.append(UndertowDeploymentInfoService.SERVICE_NAME);
        ServiceBuilder udisBuilder = serviceTarget.addService(deploymentInfoServiceName);
        Consumer diConsumer = udisBuilder.provides(new ServiceName[]{deploymentInfoServiceName, legacyDeploymentInfoServiceName});
        Supplier usSupplier = udisBuilder.requires(UndertowService.UNDERTOW);
        Supplier<SecurityDomainContext> sdcSupplier = null;
        Supplier scsSupplier = udisBuilder.requires(UndertowService.SERVLET_CONTAINER.append(new String[]{servletContainerName}));
        Supplier<Object> crSupplier = componentRegistryExists ? udisBuilder.requires(ComponentRegistry.serviceName((DeploymentUnit)deploymentUnit)) : new Supplier<ComponentRegistry>(){

            @Override
            public ComponentRegistry get() {
                return componentRegistry;
            }
        };
        Supplier hostSupplier = udisBuilder.requires(hostServiceName);
        Supplier cpSupplier = null;
        Supplier scSupplier = udisBuilder.requires(capabilitySupport.getCapabilityServiceName("org.wildfly.server.suspend-controller"));
        Supplier serverEnvSupplier = udisBuilder.requires(ServerEnvironmentService.SERVICE_NAME);
        Supplier sdSupplier = null;
        Supplier mechanismFactorySupplier = null;
        Supplier bfSupplier = null;
        for (ServiceName additionalDependency : additionalDependencies) {
            udisBuilder.requires(additionalDependency);
        }
        SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
        if (VirtualDomainMarkerUtility.isVirtualDomainRequired((DeploymentUnit)deploymentUnit) || VirtualHttpServerMechanismFactoryMarkerUtility.isVirtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit)) {
            sdSupplier = udisBuilder.requires(securityMetaData.getSecurityDomain());
        } else if (securityDomain != null) {
            if (this.mappedSecurityDomain.test(securityDomain)) {
                bfSupplier = udisBuilder.requires(((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityServiceName("org.wildfly.undertow.application-security-domain", new String[]{securityDomain}));
            } else {
                throw UndertowLogger.ROOT_LOGGER.deploymentConfiguredForLegacySecurity();
            }
        }
        if (VirtualHttpServerMechanismFactoryMarkerUtility.isVirtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit) && securityMetaData instanceof AdvancedSecurityMetaData) {
            mechanismFactorySupplier = udisBuilder.requires(((AdvancedSecurityMetaData)securityMetaData).getHttpServerAuthenticationMechanismFactory());
        }
        if (RequestControllerActivationMarker.isRequestControllerEnabled((DeploymentUnit)deploymentUnit)) {
            String topLevelName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName();
            cpSupplier = udisBuilder.requires(ControlPointService.serviceName((String)topLevelName, (String)"undertow"));
        }
        if (sharedSessionManagerConfig != null) {
            ServiceName parentSN = deploymentUnit.getParent().getServiceName();
            smfSupplier = udisBuilder.requires(parentSN.append(SharedSessionManagerConfig.SHARED_SESSION_MANAGER_SERVICE_NAME));
            sicSupplier = udisBuilder.requires(parentSN.append(SharedSessionManagerConfig.SHARED_SESSION_IDENTIFIER_CODEC_SERVICE_NAME));
        } else {
            ServletContainerService servletContainer = (ServletContainerService)deploymentUnit.getAttachment(UndertowAttachments.SERVLET_CONTAINER_SERVICE);
            final Integer maxActiveSessions = metaData.getMaxActiveSessions() != null ? metaData.getMaxActiveSessions() : (servletContainer != null ? servletContainer.getMaxSessions() : null);
            SessionConfigMetaData sessionConfig = metaData.getSessionConfig();
            final int defaultSessionTimeout = sessionConfig != null && sessionConfig.getSessionTimeoutSet() ? sessionConfig.getSessionTimeout() : (servletContainer != null ? servletContainer.getDefaultSessionTimeout() : Integer.valueOf(30).intValue());
            ServiceName factoryServiceName = deploymentServiceName.append(new String[]{"session"});
            ServiceName codecServiceName = deploymentServiceName.append(new String[]{"codec"});
            SessionManagementProvider provider = this.getDistributableWebDeploymentProvider(deploymentUnit, metaData);
            SessionManagerFactoryConfiguration configuration = new SessionManagerFactoryConfiguration(){

                public String getServerName() {
                    return serverInstanceName;
                }

                public String getDeploymentName() {
                    return deploymentName;
                }

                public Module getModule() {
                    return module;
                }

                public Integer getMaxActiveSessions() {
                    return maxActiveSessions;
                }

                public Duration getDefaultSessionTimeout() {
                    return Duration.ofMinutes(defaultSessionTimeout);
                }
            };
            CapabilityServiceConfigurator factoryConfigurator = provider.getSessionManagerFactoryServiceConfigurator(factoryServiceName, configuration);
            CapabilityServiceConfigurator codecConfigurator = provider.getSessionIdentifierCodecServiceConfigurator(codecServiceName, (WebDeploymentConfiguration)configuration);
            smfSupplier = udisBuilder.requires(factoryConfigurator.getServiceName());
            sicSupplier = udisBuilder.requires(codecConfigurator.getServiceName());
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            factoryConfigurator.configure(support).build(serviceTarget).install();
            codecConfigurator.configure(support).build(serviceTarget).install();
        }
        UndertowDeploymentInfoService undertowDeploymentInfoService = UndertowDeploymentInfoService.builder().setAttributes(deploymentUnit.getAttachmentList(ServletContextAttribute.ATTACHMENT_KEY)).setContextPath(pathName).setDeploymentName(deploymentName).setDeploymentRoot(deploymentRoot).setMergedMetaData(warMetaData.getMergedJBossWebMetaData()).setModule(module).setScisMetaData(scisMetaData).setJaccContextId(jaccContextId).setSecurityDomain(securityDomain).setTldInfo(UndertowDeploymentProcessor.createTldsInfo(tldsMetaData, tldsMetaData == null ? null : tldsMetaData.getSharedTlds(deploymentUnit))).setSetupActions(setupActions).setSharedSessionManagerConfig(sharedSessionManagerConfig).setOverlays(warMetaData.getOverlays()).setExpressionFactoryWrappers(deploymentUnit.getAttachmentList(ExpressionFactoryWrapper.ATTACHMENT_KEY)).setPredicatedHandlers((List)deploymentUnit.getAttachment(UndertowHandlersDeploymentProcessor.PREDICATED_HANDLERS)).setInitialHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_INITIAL_HANDLER_CHAIN_WRAPPERS)).setInnerHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_INNER_HANDLER_CHAIN_WRAPPERS)).setOuterHandlerChainWrappers(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_OUTER_HANDLER_CHAIN_WRAPPERS)).setThreadSetupActions(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_THREAD_SETUP_ACTIONS)).setServletExtensions(deploymentUnit.getAttachmentList(UndertowAttachments.UNDERTOW_SERVLET_EXTENSIONS)).setExplodedDeployment(ExplodedDeploymentMarker.isExplodedDeployment((DeploymentUnit)deploymentUnit)).setWebSocketDeploymentInfo((WebSocketDeploymentInfo)deploymentUnit.getAttachment(UndertowAttachments.WEB_SOCKET_DEPLOYMENT_INFO)).setTempDir(warMetaData.getTempDir()).setExternalResources(deploymentUnit.getAttachmentList(UndertowAttachments.EXTERNAL_RESOURCES)).setAllowSuspendedRequests(deploymentUnit.getAttachmentList(UndertowAttachments.ALLOW_REQUEST_WHEN_SUSPENDED)).createUndertowDeploymentInfoService(diConsumer, usSupplier, smfSupplier, sicSupplier, sdcSupplier, scsSupplier, crSupplier, hostSupplier, cpSupplier, scSupplier, serverEnvSupplier, sdSupplier, mechanismFactorySupplier, bfSupplier);
        udisBuilder.setInstance((org.jboss.msc.Service)undertowDeploymentInfoService);
        HashSet<String> seenExecutors = new HashSet<String>();
        if (metaData.getExecutorName() != null) {
            Supplier executor = udisBuilder.requires(IOServices.WORKER.append(new String[]{metaData.getExecutorName()}));
            undertowDeploymentInfoService.addInjectedExecutor(metaData.getExecutorName(), executor);
            seenExecutors.add(metaData.getExecutorName());
        }
        if (metaData.getServlets() != null) {
            for (JBossServletMetaData servlet : metaData.getServlets()) {
                if (servlet.getExecutorName() == null || seenExecutors.contains(servlet.getExecutorName())) continue;
                Supplier executor = udisBuilder.requires(IOServices.WORKER.append(new String[]{servlet.getExecutorName()}));
                undertowDeploymentInfoService.addInjectedExecutor(servlet.getExecutorName(), executor);
                seenExecutors.add(servlet.getExecutorName());
            }
        }
        try {
            udisBuilder.install();
        }
        catch (DuplicateServiceException e) {
            throw UndertowLogger.ROOT_LOGGER.duplicateHostContextDeployments(deploymentInfoServiceName, e.getMessage());
        }
        ServiceBuilder udsBuilder = serviceTarget.addService(deploymentServiceName);
        Consumer sConsumer = udsBuilder.provides(new ServiceName[]{deploymentServiceName, legacyDeploymentServiceName});
        Supplier cSupplier = udsBuilder.requires(UndertowService.SERVLET_CONTAINER.append(new String[]{this.defaultContainer}));
        Supplier seSupplier = Services.requireServerExecutor((ServiceBuilder)udsBuilder);
        Supplier hSupplier = udsBuilder.requires(hostServiceName);
        Supplier diSupplier = udsBuilder.requires(deploymentInfoServiceName);
        for (ServiceName webDependency : deploymentUnit.getAttachmentList(Attachments.WEB_DEPENDENCIES)) {
            udsBuilder.requires(webDependency);
        }
        for (ServiceName dependentComponent : dependentComponents) {
            udsBuilder.requires(dependentComponent);
        }
        udsBuilder.setInstance((org.jboss.msc.Service)new UndertowDeploymentService(sConsumer, cSupplier, seSupplier, hSupplier, diSupplier, (WebInjectionContainer)injectionContainer, true));
        udsBuilder.install();
        deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)deploymentServiceName);
        boolean elytronJacc = capabilitySupport.hasCapability(ELYTRON_JACC_CAPABILITY_NAME);
        boolean bl = legacyJacc = !elytronJacc && UndertowDeploymentProcessor.legacySecurityInstalled(deploymentUnit);
        if ((legacyJacc || elytronJacc) && (jaccService = (deployer = new WarJACCDeployer()).deploy(deploymentUnit, jaccContextId)) != null) {
            ServiceName jaccServiceName = deploymentUnit.getServiceName().append(JaccService.SERVICE_NAME);
            ServiceBuilder jaccBuilder = serviceTarget.addService(jaccServiceName, (Service)jaccService);
            if (deploymentUnit.getParent() != null) {
                DeploymentUnit parentDU = deploymentUnit.getParent();
                jaccBuilder.addDependency(parentDU.getServiceName().append(JaccService.SERVICE_NAME), PolicyConfiguration.class, jaccService.getParentPolicyInjector());
            }
            jaccBuilder.addDependency(capabilitySupport.getCapabilityServiceName(elytronJacc ? ELYTRON_JACC_CAPABILITY_NAME : LEGACY_JACC_CAPABILITY_NAME));
            jaccBuilder.requires(deploymentServiceName);
            jaccBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        }
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        ModelNode node = deploymentResourceSupport.getDeploymentSubsystemModel("undertow");
        node.get(DeploymentDefinition.CONTEXT_ROOT.getName()).set("".equals(pathName) ? "/" : pathName);
        node.get(DeploymentDefinition.VIRTUAL_HOST.getName()).set(hostName);
        node.get(DeploymentDefinition.SERVER.getName()).set(serverInstanceName);
        this.processManagement(deploymentUnit, metaData);
    }

    private static boolean legacySecurityInstalled(DeploymentUnit deploymentUnit) {
        CapabilityServiceSupport capabilities = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        return capabilities.hasCapability("org.wildfly.legacy-security");
    }

    @Override
    public SessionManagerFactory apply(SessionManagerFactoryConfiguration configuration) {
        Integer maxActiveSessions = configuration.getMaxActiveSessions();
        return maxActiveSessions != null ? new InMemorySessionManagerFactory(maxActiveSessions.intValue()) : new InMemorySessionManagerFactory();
    }

    private SessionManagementProvider getDistributableWebDeploymentProvider(DeploymentUnit unit, JBossWebMetaData metaData) {
        if (metaData.getDistributable() != null) {
            if (this.sessionManagementProviderFactory != null) {
                return this.sessionManagementProviderFactory.createSessionManagementProvider(unit, metaData.getReplicationConfig());
            }
            UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
        }
        return this.nonDistributableSessionManagementProvider;
    }

    static String pathNameOfDeployment(DeploymentUnit deploymentUnit, JBossWebMetaData metaData, boolean isDefaultWebModule) {
        String pathName;
        if (isDefaultWebModule) {
            pathName = "/";
        } else if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            pathName = description != null ? "/" + description.getModuleName() : "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        return pathName;
    }

    void processManagement(DeploymentUnit unit, JBossWebMetaData metaData) {
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)unit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (JBossServletMetaData servlet : metaData.getServlets()) {
            try {
                String name = servlet.getName();
                ModelNode node = deploymentResourceSupport.getDeploymentSubModel("undertow", PathElement.pathElement((String)"servlet", (String)name));
                node.get("servlet-class").set(servlet.getServletClass());
                node.get("servlet-name").set(servlet.getServletName());
            }
            catch (Exception e) {}
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(ServletContextAttribute.ATTACHMENT_KEY);
    }

    private static HashMap<String, TagLibraryInfo> createTldsInfo(TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds) {
        HashMap<String, TagLibraryInfo> ret = new HashMap<String, TagLibraryInfo>();
        if (tldsMetaData != null) {
            if (tldsMetaData.getTlds() != null) {
                for (Map.Entry entry : tldsMetaData.getTlds().entrySet()) {
                    UndertowDeploymentProcessor.createTldInfo((String)entry.getKey(), (TldMetaData)entry.getValue(), ret);
                }
            }
            if (sharedTlds != null) {
                for (TldMetaData tldMetaData : sharedTlds) {
                    UndertowDeploymentProcessor.createTldInfo(null, tldMetaData, ret);
                }
            }
        }
        for (String string : new HashSet(ret.keySet())) {
            if (string == null || !string.startsWith(OLD_URI_PREFIX)) continue;
            String newUri = string.replace(OLD_URI_PREFIX, NEW_URI_PREFIX);
            ret.put(newUri, ret.get(string));
        }
        return ret;
    }

    private static TagLibraryInfo createTldInfo(String location, TldMetaData tldMetaData, HashMap<String, TagLibraryInfo> ret) {
        int pos;
        String relativeLocation = location;
        String jarPath = null;
        if (relativeLocation != null && relativeLocation.startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
            jarPath = relativeLocation.substring(pos);
            if (jarPath.startsWith("/")) {
                jarPath = jarPath.substring(1);
            }
            relativeLocation = relativeLocation.substring(0, pos);
        }
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        if (tldMetaData.getListeners() != null) {
            for (Object l : tldMetaData.getListeners()) {
                tagLibraryInfo.addListener(l.getListenerClass());
            }
        }
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                        tagAttributeInfo.setName(attributeMetaData.getName());
                        tagAttributeInfo.setType(attributeMetaData.getType());
                        tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                        tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                        tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            tagAttributeInfo.setDeferredValue("true");
                            tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            tagAttributeInfo.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            tagAttributeInfo.setDeferredMethod("true");
                            tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            tagAttributeInfo.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(tagAttributeInfo);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tagFileInfo = new TagFileInfo();
                tagFileInfo.setName(tagFileMetaData.getName());
                tagFileInfo.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tagFileInfo);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo functionInfo = new FunctionInfo();
                functionInfo.setName(functionMetaData.getName());
                functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(functionInfo);
            }
        }
        if (jarPath == null && relativeLocation == null) {
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
        } else if (jarPath == null) {
            tagLibraryInfo.setLocation("");
            tagLibraryInfo.setPath(relativeLocation);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            ret.put(relativeLocation, tagLibraryInfo);
        } else {
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            if (jarPath.equals("META-INF/taglib.tld")) {
                ret.put(relativeLocation, tagLibraryInfo);
            }
        }
        return tagLibraryInfo;
    }
}

