/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.EventInvoker;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowService
implements Service<UndertowService> {
    @Deprecated
    public static final ServiceName UNDERTOW = ServiceName.JBOSS.append(new String[]{"undertow"});
    @Deprecated
    public static final ServiceName SERVLET_CONTAINER = UNDERTOW.append(new String[]{"servlet-container"});
    @Deprecated
    public static final ServiceName SERVER = UNDERTOW.append(new String[]{"server"});
    public static final ServiceName DEFAULT_SERVER = UNDERTOW.append(new String[]{"default-server"});
    public static final ServiceName DEFAULT_HOST = DEFAULT_SERVER.append(new String[]{"default-host"});
    public static final ServiceName UNDERTOW_DEPLOYMENT = ServiceName.of((String[])new String[]{"undertow-deployment"});
    public static final ServiceName HANDLER = UNDERTOW.append(new String[]{"handler"});
    public static final ServiceName FILTER = UNDERTOW.append(new String[]{"filter"});
    static final ServiceName WEB_DEPLOYMENT_BASE = UNDERTOW.append(new String[]{"deployment"});
    private final String defaultContainer;
    private final String defaultServer;
    private final String defaultVirtualHost;
    private final Set<Server> registeredServers = new CopyOnWriteArraySet<Server>();
    private final List<UndertowEventListener> listeners = Collections.synchronizedList(new LinkedList());
    private final String instanceId;
    private final boolean obfuscateSessionRoute;
    private volatile boolean statisticsEnabled;
    private final Set<Consumer<Boolean>> statisticsChangeListenters = new HashSet<Consumer<Boolean>>();
    private final Consumer<UndertowService> serviceConsumer;

    protected UndertowService(Consumer<UndertowService> serviceConsumer, String defaultContainer, String defaultServer, String defaultVirtualHost, String instanceId, boolean obfuscateSessionRoute, boolean statisticsEnabled) {
        this.serviceConsumer = serviceConsumer;
        this.defaultContainer = defaultContainer;
        this.defaultServer = defaultServer;
        this.defaultVirtualHost = defaultVirtualHost;
        this.instanceId = instanceId;
        this.obfuscateSessionRoute = obfuscateSessionRoute;
        this.statisticsEnabled = statisticsEnabled;
    }

    public static ServiceName deploymentServiceName(ServiceName deploymentServiceName) {
        return deploymentServiceName.append(UNDERTOW_DEPLOYMENT);
    }

    @Deprecated
    public static ServiceName deploymentServiceName(String serverName, String virtualHost, String contextPath) {
        return WEB_DEPLOYMENT_BASE.append(new String[]{serverName}).append(new String[]{virtualHost}).append(new String[]{"".equals(contextPath) ? "/" : contextPath});
    }

    @Deprecated
    public static ServiceName virtualHostName(String server, String virtualHost) {
        return SERVER.append(new String[]{server}).append(new String[]{virtualHost});
    }

    public static ServiceName locationServiceName(String server, String virtualHost, String locationName) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"location", locationName});
    }

    public static ServiceName accessLogServiceName(String server, String virtualHost) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"access-log"});
    }

    public static ServiceName ssoServiceName(String server, String virtualHost) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"single-sign-on"});
    }

    public static ServiceName consoleRedirectServiceName(String server, String virtualHost) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"console", "redirect"});
    }

    public static ServiceName filterRefName(String server, String virtualHost, String locationName, String filterName) {
        return UndertowService.virtualHostName(server, virtualHost).append(new String[]{"location", locationName}).append(new String[]{"filter-ref"}).append(new String[]{filterName});
    }

    public static ServiceName filterRefName(String server, String virtualHost, String filterName) {
        return SERVER.append(new String[]{server}).append(new String[]{virtualHost}).append(new String[]{"filter-ref"}).append(new String[]{filterName});
    }

    public static ServiceName getFilterRefServiceName(PathAddress address, String name) {
        ServiceName serviceName;
        PathAddress oneUp = address.subAddress(0, address.size() - 1);
        PathAddress twoUp = oneUp.subAddress(0, oneUp.size() - 1);
        PathAddress threeUp = twoUp.subAddress(0, twoUp.size() - 1);
        if (address.getLastElement().getKey().equals("filter-ref")) {
            if (oneUp.getLastElement().getKey().equals("host")) {
                String host = oneUp.getLastElement().getValue();
                String server = twoUp.getLastElement().getValue();
                serviceName = UndertowService.filterRefName(server, host, name);
            } else {
                String location = oneUp.getLastElement().getValue();
                String host = twoUp.getLastElement().getValue();
                String server = threeUp.getLastElement().getValue();
                serviceName = UndertowService.filterRefName(server, host, location, name);
            }
        } else if (address.getLastElement().getKey().equals("host")) {
            String host = address.getLastElement().getValue();
            String server = oneUp.getLastElement().getValue();
            serviceName = UndertowService.filterRefName(server, host, name);
        } else {
            String location = address.getLastElement().getValue();
            String host = oneUp.getLastElement().getValue();
            String server = twoUp.getLastElement().getValue();
            serviceName = UndertowService.filterRefName(server, host, location, name);
        }
        return serviceName;
    }

    @Deprecated
    public static ServiceName listenerName(String listenerName) {
        return UNDERTOW.append(new String[]{"listener"}).append(new String[]{listenerName});
    }

    public void start(StartContext context) throws StartException {
        UndertowLogger.ROOT_LOGGER.serverStarting(Version.getVersionString());
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        UndertowLogger.ROOT_LOGGER.serverStopping(Version.getVersionString());
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onShutdown();
            }
        });
    }

    public UndertowService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected void registerServer(final Server server) {
        this.registeredServers.add(server);
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onServerStart(server);
            }
        });
    }

    protected void unregisterServer(final Server server) {
        this.registeredServers.remove(server);
        this.fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onServerStop(server);
            }
        });
    }

    public String getDefaultContainer() {
        return this.defaultContainer;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public String getDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.registeredServers);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isObfuscateSessionRoute() {
        return this.obfuscateSessionRoute;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public synchronized void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        for (Consumer<Boolean> listener : this.statisticsChangeListenters) {
            listener.accept(statisticsEnabled);
        }
    }

    public synchronized void registerStatisticsListener(Consumer<Boolean> listener) {
        this.statisticsChangeListenters.add(listener);
    }

    public synchronized void unregisterStatisticsListener(Consumer<Boolean> listener) {
        this.statisticsChangeListenters.remove(listener);
    }

    public void registerListener(UndertowEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(UndertowEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(EventInvoker invoker) {
        List<UndertowEventListener> list = this.listeners;
        synchronized (list) {
            for (UndertowEventListener listener : this.listeners) {
                invoker.invoke(listener);
            }
        }
    }
}

