/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.filters.PredicateHandlerWrapper;
import org.wildfly.extension.undertow.filters.SimpleFilterDefinition;

public class ResponseHeaderFilterDefinition
extends SimpleFilterDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"response-header");
    public static final AttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("header-name", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("header-value", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(NAME, VALUE);

    ResponseHeaderFilterDefinition() {
        super(PATH_ELEMENT, ResponseHeaderFilterDefinition::createHandlerWrapper);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static PredicateHandlerWrapper createHandlerWrapper(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = NAME.resolveModelAttribute(context, model).asString();
        final String value = VALUE.resolveModelAttribute(context, model).asString();
        return PredicateHandlerWrapper.filter(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler next) {
                return new SetHeaderHandler(next, name, value);
            }
        });
    }
}

