/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.jws.WebService;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.webservices.webserviceref.WSRefAnnotationWrapper;
import org.jboss.as.webservices.webserviceref.WebServiceReferences;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.ManagedReferenceFactoryToResourceReferenceFactoryAdapter;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.reflection.Reflections;

public class WeldJaxwsInjectionServices
implements JaxwsInjectionServices {
    private DeploymentUnit deploymentUnit;

    public WeldJaxwsInjectionServices(DeploymentUnit unit) {
        this.deploymentUnit = unit;
    }

    public <T> ResourceReferenceFactory<T> registerWebServiceRefInjectionPoint(InjectionPoint injectionPoint) {
        WebServiceRef annotation = (WebServiceRef)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(WebServiceRef.class);
        if (annotation == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(WebServiceRef.class, injectionPoint.getMember());
        }
        this.validateWebServiceRefInjectionPoint(injectionPoint, annotation);
        try {
            ManagedReferenceFactory factory = WebServiceReferences.createWebServiceFactory((DeploymentUnit)this.deploymentUnit, (String)this.classNameFromType(injectionPoint.getType()), (WSRefAnnotationWrapper)new WSRefAnnotationWrapper(annotation), (AnnotatedElement)((AnnotatedElement)((Object)injectionPoint.getMember())), (String)this.getBindingName(injectionPoint, annotation));
            return new ManagedReferenceFactoryToResourceReferenceFactoryAdapter(factory);
        }
        catch (DeploymentUnitProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getBindingName(InjectionPoint injectionPoint, WebServiceRef annotation) {
        if (!annotation.name().isEmpty()) {
            return annotation.name();
        }
        return injectionPoint.getMember().getDeclaringClass().getName() + "/" + ResourceInjectionUtilities.getPropertyName(injectionPoint.getMember());
    }

    private String classNameFromType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            return this.classNameFromType(((ParameterizedType)type).getRawType());
        }
        return type.toString();
    }

    private void validateWebServiceRefInjectionPoint(InjectionPoint ip, WebServiceRef annotation) {
        Class rawType = Reflections.getRawType((Type)ip.getType());
        if (Service.class.isAssignableFrom(rawType)) {
            return;
        }
        if (!rawType.isAnnotationPresent(WebService.class)) {
            throw BeanLogger.LOG.invalidResourceProducerType((Object)ip.getAnnotated(), (Object)annotation.value());
        }
    }

    public void cleanup() {
        this.deploymentUnit = null;
    }
}

