/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.jandex.DotName;

public enum CdiAnnotations {
    DECORATOR(Constants.JAVAX_DECORATOR, "Decorator"),
    DELEGATE(Constants.JAVAX_DECORATOR, "Delegate"),
    APP_SCOPED(Constants.JAVAX_ENT_CONTEXT, "ApplicationScoped"),
    CONV_SCOPED(Constants.JAVAX_ENT_CONTEXT, "ConversationScoped"),
    REQ_SCOPED(Constants.JAVAX_ENT_CONTEXT, "RequestScoped"),
    SESS_SCOPED(Constants.JAVAX_ENT_CONTEXT, "SessionScoped"),
    NORM_SCOPE(Constants.JAVAX_ENT_CONTEXT, "NormalScope"),
    DEPENDENT(Constants.JAVAX_ENT_CONTEXT, "Dependent"),
    SINGLETON(Constants.JAVAX_INJ, "Singleton"),
    OBSERVES(Constants.JAVAX_ENT_EVT, "Observes"),
    ALTERNATIVE(Constants.JAVAX_ENT_INJ, "Alternative"),
    ANY(Constants.JAVAX_ENT_INJ, "Any"),
    DEFAULT(Constants.JAVAX_ENT_INJ, "Default"),
    DISPOSES(Constants.JAVAX_ENT_INJ, "Disposes"),
    MODEL(Constants.JAVAX_ENT_INJ, "Model"),
    NEW(Constants.JAVAX_ENT_INJ, "New"),
    PRODUCES(Constants.JAVAX_ENT_INJ, "Produces"),
    SPECIALIZES(Constants.JAVAX_ENT_INJ, "Specializes"),
    STEREOTYPE(Constants.JAVAX_ENT_INJ, "Stereotype"),
    TYPED(Constants.JAVAX_ENT_INJ, "Typed");

    private final String simpleName;
    private final DotName dotName;
    public static final DotName SCOPE;
    public static final Set<DotName> BUILT_IN_SCOPE_NAMES;
    public static final Set<AnnotationType> BUILT_IN_SCOPES;
    public static final Set<AnnotationType> BEAN_DEFINING_ANNOTATIONS;
    public static final Set<AnnotationType> BEAN_DEFINING_META_ANNOTATIONS;

    private CdiAnnotations(DotName prefix, String simpleName) {
        this.simpleName = simpleName;
        this.dotName = DotName.createComponentized((DotName)prefix, (String)simpleName);
    }

    public DotName getDotName() {
        return this.dotName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    private static AnnotationType asAnnotationType(CdiAnnotations annotation) {
        return new AnnotationType(annotation.getDotName(), true);
    }

    private static AnnotationType asAnnotationType(CdiAnnotations annotation, boolean inherited) {
        return new AnnotationType(annotation.getDotName(), inherited);
    }

    static {
        SCOPE = DotName.createComponentized((DotName)Constants.JAVAX_INJ, (String)"Scope");
        BUILT_IN_SCOPE_NAMES = ImmutableSet.of((Object)DEPENDENT.getDotName(), (Object)REQ_SCOPED.getDotName(), (Object)CONV_SCOPED.getDotName(), (Object)SESS_SCOPED.getDotName(), (Object)APP_SCOPED.getDotName(), (Object)SINGLETON.getDotName(), (Object[])new DotName[0]);
        BUILT_IN_SCOPES = ImmutableSet.copyOf((Collection)Collections2.transform(BUILT_IN_SCOPE_NAMES, (Function)new Function<DotName, AnnotationType>(){

            public AnnotationType apply(DotName input) {
                return new AnnotationType(input, true);
            }
        }));
        BEAN_DEFINING_ANNOTATIONS = ImmutableSet.of((Object)new AnnotationType(DotName.createComponentized((DotName)Constants.JAVAX_INTERCEPTOR, (String)"Interceptor"), false), (Object)CdiAnnotations.asAnnotationType(DECORATOR, false), (Object)CdiAnnotations.asAnnotationType(DEPENDENT), (Object)CdiAnnotations.asAnnotationType(REQ_SCOPED), (Object)CdiAnnotations.asAnnotationType(CONV_SCOPED), (Object)CdiAnnotations.asAnnotationType(SESS_SCOPED), (Object[])new AnnotationType[]{CdiAnnotations.asAnnotationType(APP_SCOPED)});
        BEAN_DEFINING_META_ANNOTATIONS = ImmutableSet.of((Object)CdiAnnotations.asAnnotationType(NORM_SCOPE, false), (Object)CdiAnnotations.asAnnotationType(STEREOTYPE, false));
    }

    private static class Constants {
        public static final DotName JAVAX = DotName.createComponentized(null, (String)"javax");
        public static final DotName JAVAX_INTERCEPTOR = DotName.createComponentized((DotName)JAVAX, (String)"interceptor");
        public static final DotName JAVAX_DECORATOR = DotName.createComponentized((DotName)JAVAX, (String)"decorator");
        public static final DotName JAVAX_ENT = DotName.createComponentized((DotName)JAVAX, (String)"enterprise");
        public static final DotName JAVAX_ENT_CONTEXT = DotName.createComponentized((DotName)JAVAX_ENT, (String)"context");
        public static final DotName JAVAX_ENT_EVT = DotName.createComponentized((DotName)JAVAX_ENT, (String)"event");
        public static final DotName JAVAX_ENT_INJ = DotName.createComponentized((DotName)JAVAX_ENT, (String)"inject");
        public static final DotName JAVAX_INJ = DotName.createComponentized((DotName)JAVAX, (String)"inject");

        private Constants() {
        }
    }
}

