/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.deployment.BeanArchiveMetadata;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeploymentMetadata;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.services.bootstrap.WeldJaxwsInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class BeanArchiveProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WeldDeploymentMetadata cdiDeploymentMetadata = (WeldDeploymentMetadata)deploymentUnit.getAttachment(WeldDeploymentMetadata.ATTACHMENT_KEY);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        String beanArchiveIdPrefix = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "." + deploymentUnit.getName();
        HashSet<BeanDeploymentArchiveImpl> beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>();
        WeldLogger.DEPLOYMENT_LOGGER.processingWeldDeployment(phaseContext.getDeploymentUnit().getName());
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        HashMap<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap = new HashMap<ResourceRoot, BeanDeploymentArchiveImpl>();
        Module module = (Module)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        BeanDeploymentArchiveImpl rootBda = null;
        if (cdiDeploymentMetadata != null) {
            for (BeanArchiveMetadata beanArchiveMetadata : cdiDeploymentMetadata.getBeanArchiveMetadata()) {
                boolean isRootBda = beanArchiveMetadata.isDeploymentRoot();
                BeanDeploymentArchiveImpl bda = this.createBeanDeploymentArchive((Index)indexes.get(beanArchiveMetadata.getResourceRoot()), beanArchiveMetadata, module, beanArchiveIdPrefix, isRootBda);
                beanDeploymentArchives.add(bda);
                bdaMap.put(beanArchiveMetadata.getResourceRoot(), bda);
                if (!isRootBda) continue;
                rootBda = bda;
                deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, (Object)bda);
            }
        }
        if (rootBda == null) {
            BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(Collections.emptySet(), BeansXml.EMPTY_BEANS_XML, module, beanArchiveIdPrefix, true);
            beanDeploymentArchives.add(bda);
            deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, (Object)bda);
            rootBda = bda;
        }
        this.processEEComponents(deploymentUnit, bdaMap, rootBda, indexes, reflectionIndex);
        WeldJpaInjectionServices jpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit);
        WeldJaxwsInjectionServices jaxwsInjectionServices = new WeldJaxwsInjectionServices(deploymentUnit);
        BeanDeploymentModule bdm = new BeanDeploymentModule(beanDeploymentArchives);
        bdm.addService(JpaInjectionServices.class, jpaInjectionServices);
        bdm.addService(JaxwsInjectionServices.class, jaxwsInjectionServices);
        deploymentUnit.putAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE, (Object)bdm);
    }

    private void processEEComponents(DeploymentUnit deploymentUnit, Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, BeanDeploymentArchiveImpl rootBda, Map<ResourceRoot, Index> indexes, DeploymentReflectionIndex reflectionIndex) {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            BeanDeploymentArchiveImpl bda = this.resolveComponentBda(component.getComponentClassName(), bdaMap, rootBda, indexes);
            component.setBeanDeploymentArchiveId(bda.getId());
            if (!(component instanceof EJBComponentDescription)) continue;
            EJBComponentDescription componentDescription = (EJBComponentDescription)component;
            bda.addEjbDescriptor(new EjbDescriptorImpl(componentDescription, bda, reflectionIndex));
        }
    }

    private BeanDeploymentArchiveImpl resolveComponentBda(String ejbClassName, Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, BeanDeploymentArchiveImpl rootBda, Map<ResourceRoot, Index> indexes) {
        DotName className = DotName.createSimple((String)ejbClassName);
        for (Map.Entry<ResourceRoot, BeanDeploymentArchiveImpl> entry : bdaMap.entrySet()) {
            Index index = indexes.get(entry.getKey());
            if (index == null || index.getClassByName(className) == null) continue;
            return entry.getValue();
        }
        return rootBda;
    }

    private BeanDeploymentArchiveImpl createBeanDeploymentArchive(Index index, BeanArchiveMetadata beanArchiveMetadata, Module module, String beanArchivePrefix, boolean root) throws DeploymentUnitProcessingException {
        HashSet<String> classNames = new HashSet<String>();
        if (index != null) {
            for (ClassInfo classInfo : index.getKnownClasses()) {
                classNames.add(classInfo.name().toString());
            }
        }
        String beanArchiveId = beanArchivePrefix;
        if (beanArchiveMetadata.getResourceRoot() != null) {
            beanArchiveId = beanArchiveId + beanArchiveMetadata.getResourceRoot().getRoot().getPathName();
        }
        return new BeanDeploymentArchiveImpl(classNames, beanArchiveMetadata.getBeansXml(), module, beanArchiveId, root);
    }

    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        context.removeAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
    }
}

