/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.WeldMessages;
import org.jboss.weld.injection.ParameterInjectionPoint;

public class ResourceInjectionUtilities {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";

    private ResourceInjectionUtilities() {
    }

    public static String getResourceName(String jndiName, String mappedName) {
        if (mappedName != null) {
            return mappedName;
        }
        if (jndiName != null) {
            return jndiName;
        }
        throw WeldMessages.MESSAGES.cannotDetermineResourceName();
    }

    public static String getResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource = (Resource)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            int firstSlash = name.indexOf("/");
            int colon = name.indexOf(":");
            if (colon != -1 && (firstSlash == -1 || colon < firstSlash)) {
                return name;
            }
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ResourceInjectionUtilities.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw WeldMessages.MESSAGES.injectionPointNotAJavabean((Method)injectionPoint.getMember());
            }
        } else {
            throw WeldMessages.MESSAGES.cannotInject(injectionPoint);
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    public static String getEjbBindLocation(InjectionPoint injectionPoint) {
        String propertyName;
        EJB ejb = (EJB)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(EJB.class);
        String mappedName = ejb.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = ejb.name();
        if (!name.equals("")) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ResourceInjectionUtilities.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw WeldMessages.MESSAGES.injectionPointNotAJavabean((Method)injectionPoint.getMember());
            }
        } else {
            throw WeldMessages.MESSAGES.cannotInject(injectionPoint);
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.matches("^(set).*") && method.getParameterTypes().length == 1) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static String getPropertyName(Member member) {
        if (member instanceof Method) {
            return ResourceInjectionUtilities.getPropertyName((Method)member);
        }
        return member.getName();
    }

    public static Annotated getResourceAnnotated(InjectionPoint injectionPoint) {
        if (injectionPoint instanceof ParameterInjectionPoint) {
            return ((ParameterInjectionPoint)injectionPoint).getAnnotated().getDeclaringCallable();
        }
        return injectionPoint.getAnnotated();
    }
}

