/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import wiremock.com.networknt.schema.resource.MapSchemaMapper;
import wiremock.com.networknt.schema.resource.PrefixSchemaMapper;
import wiremock.com.networknt.schema.resource.SchemaMapper;

public class SchemaMappers
extends ArrayList<SchemaMapper> {
    private static final long serialVersionUID = 1L;

    public SchemaMappers() {
    }

    public SchemaMappers(Collection<? extends SchemaMapper> c) {
        super(c);
    }

    public SchemaMappers(int initialCapacity) {
        super(initialCapacity);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SchemaMappers values = new SchemaMappers();

        public Builder() {
        }

        public Builder(Builder copy) {
            this.values.addAll(copy.values);
        }

        public Builder with(Builder builder) {
            if (!builder.values.isEmpty()) {
                this.values.addAll(builder.values);
            }
            return this;
        }

        public Builder values(Consumer<List<SchemaMapper>> customizer) {
            customizer.accept(this.values);
            return this;
        }

        public Builder add(SchemaMapper schemaMapper) {
            this.values.add(schemaMapper);
            return this;
        }

        public Builder mapPrefix(String source, String replacement) {
            this.values.add(new PrefixSchemaMapper(source, replacement));
            return this;
        }

        public Builder mappings(Map<String, String> mappings) {
            this.values.add(new MapSchemaMapper(mappings));
            return this;
        }

        public Builder mappings(Function<String, String> mappings) {
            this.values.add(new MapSchemaMapper(mappings));
            return this;
        }

        public Builder mappings(Predicate<String> test, Function<String, String> mappings) {
            this.values.add(new MapSchemaMapper(test, mappings));
            return this;
        }

        public SchemaMappers build() {
            return this.values;
        }
    }
}

