/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpResponse;
import wiremock.org.apache.hc.core5.http.HttpVersion;
import wiremock.org.apache.hc.core5.http.config.Http1Config;
import wiremock.org.apache.hc.core5.http.impl.io.AbstractMessageWriter;
import wiremock.org.apache.hc.core5.http.message.LineFormatter;
import wiremock.org.apache.hc.core5.http.message.StatusLine;
import wiremock.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpResponseWriter
extends AbstractMessageWriter<ClassicHttpResponse> {
    private final Http1Config http1Config;

    public DefaultHttpResponseWriter(Http1Config http1Config, LineFormatter formatter) {
        super(formatter);
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
    }

    public DefaultHttpResponseWriter(LineFormatter formatter) {
        this(null, formatter);
    }

    public DefaultHttpResponseWriter() {
        this(null, null);
    }

    protected HttpVersion protocolVersion(HttpResponse message) {
        return this.http1Config.getVersion();
    }

    @Override
    protected void writeHeadLine(ClassicHttpResponse message, CharArrayBuffer lineBuf) throws IOException {
        this.getLineFormatter().formatStatusLine(lineBuf, new StatusLine(this.protocolVersion(message), message.getCode(), message.getReasonPhrase()));
    }
}

