/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.CommonContentHeaderProperties;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.FieldTableFactory;

public class BasicContentHeaderProperties
implements CommonContentHeaderProperties {
    public static final int NON_PERSISTENT = 1;
    public static final int PERSISTENT = 2;
    private static final Logger _logger = LoggerFactory.getLogger(BasicContentHeaderProperties.class);
    private static final AMQShortString ZERO_STRING = null;
    private byte[] _encodedForm;
    private boolean _decoded = true;
    private boolean _decodedHeaders = true;
    private boolean _decodedContentType = true;
    private AMQShortString _contentType;
    private AMQShortString _encoding;
    private FieldTable _headers;
    private byte _deliveryMode;
    private byte _priority;
    private AMQShortString _correlationId;
    private AMQShortString _replyTo;
    private long _expiration;
    private AMQShortString _messageId;
    private long _timestamp;
    private AMQShortString _type;
    private AMQShortString _userId;
    private AMQShortString _appId;
    private AMQShortString _clusterId;
    private int _propertyFlags = 0;
    private static final int CONTENT_TYPE_MASK = 32768;
    private static final int ENCONDING_MASK = 16384;
    private static final int HEADERS_MASK = 8192;
    private static final int DELIVERY_MODE_MASK = 4096;
    private static final int PROPRITY_MASK = 2048;
    private static final int CORRELATION_ID_MASK = 1024;
    private static final int REPLY_TO_MASK = 512;
    private static final int EXPIRATION_MASK = 256;
    private static final int MESSAGE_ID_MASK = 128;
    private static final int TIMESTAMP_MASK = 64;
    private static final int TYPE_MASK = 32;
    private static final int USER_ID_MASK = 16;
    private static final int APPLICATION_ID_MASK = 8;
    private static final int CLUSTER_ID_MASK = 4;
    private boolean _hasBeenUpdated = false;

    public boolean reset() {
        boolean result = this._hasBeenUpdated;
        this._hasBeenUpdated = false;
        return result;
    }

    public void updated() {
        this._hasBeenUpdated = true;
    }

    public int getPropertyListSize() {
        if (this._encodedForm != null) {
            return this._encodedForm.length;
        }
        int size = 0;
        if ((this._propertyFlags & 0x8000) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._contentType);
        }
        if ((this._propertyFlags & 0x4000) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._encoding);
        }
        if ((this._propertyFlags & 0x2000) > 0) {
            size += EncodingUtils.encodedFieldTableLength(this._headers);
        }
        if ((this._propertyFlags & 0x1000) > 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x800) > 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x400) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._correlationId);
        }
        if ((this._propertyFlags & 0x200) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._replyTo);
        }
        if ((this._propertyFlags & 0x100) > 0) {
            size = this._expiration == 0L ? (size += EncodingUtils.encodedShortStringLength(ZERO_STRING)) : (size += EncodingUtils.encodedShortStringLength(this._expiration));
        }
        if ((this._propertyFlags & 0x80) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._messageId);
        }
        if ((this._propertyFlags & 0x40) > 0) {
            size += 8;
        }
        if ((this._propertyFlags & 0x20) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._type);
        }
        if ((this._propertyFlags & 0x10) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._userId);
        }
        if ((this._propertyFlags & 8) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._appId);
        }
        if ((this._propertyFlags & 4) > 0) {
            size += EncodingUtils.encodedShortStringLength(this._clusterId);
        }
        return size;
    }

    private void clearEncodedForm() {
        if (this._decoded || this._encodedForm != null) {
            // empty if block
        }
        this._encodedForm = null;
    }

    public void setPropertyFlags(int propertyFlags) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags = propertyFlags;
    }

    public int getPropertyFlags() {
        return this._propertyFlags;
    }

    public void writePropertyListPayload(ByteBuffer buffer) {
        if (this._encodedForm != null) {
            buffer.put(this._encodedForm);
        } else {
            if ((this._propertyFlags & 0x8000) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._contentType);
            }
            if ((this._propertyFlags & 0x4000) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._encoding);
            }
            if ((this._propertyFlags & 0x2000) != 0) {
                EncodingUtils.writeFieldTableBytes(buffer, this._headers);
            }
            if ((this._propertyFlags & 0x1000) != 0) {
                buffer.put(this._deliveryMode);
            }
            if ((this._propertyFlags & 0x800) != 0) {
                buffer.put(this._priority);
            }
            if ((this._propertyFlags & 0x400) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._correlationId);
            }
            if ((this._propertyFlags & 0x200) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._replyTo);
            }
            if ((this._propertyFlags & 0x100) != 0) {
                if (this._expiration == 0L) {
                    EncodingUtils.writeShortStringBytes(buffer, ZERO_STRING);
                } else {
                    EncodingUtils.writeShortStringBytes(buffer, String.valueOf(this._expiration));
                }
            }
            if ((this._propertyFlags & 0x80) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._messageId);
            }
            if ((this._propertyFlags & 0x40) != 0) {
                EncodingUtils.writeTimestamp(buffer, this._timestamp);
            }
            if ((this._propertyFlags & 0x20) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._type);
            }
            if ((this._propertyFlags & 0x10) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._userId);
            }
            if ((this._propertyFlags & 8) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._appId);
            }
            if ((this._propertyFlags & 4) != 0) {
                EncodingUtils.writeShortStringBytes(buffer, this._clusterId);
            }
        }
    }

    public void populatePropertiesFromBuffer(ByteBuffer buffer, int propertyFlags, int size) throws AMQFrameDecodingException {
        this._propertyFlags = propertyFlags;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Property flags: " + this._propertyFlags);
        }
        this.decode(buffer);
    }

    private void decode(ByteBuffer buffer) {
        int pos = buffer.position();
        try {
            if ((this._propertyFlags & 0x8000) != 0) {
                this._contentType = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x4000) != 0) {
                this._encoding = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x2000) != 0) {
                this._headers = EncodingUtils.readFieldTable(buffer);
            }
            if ((this._propertyFlags & 0x1000) != 0) {
                this._deliveryMode = buffer.get();
            }
            if ((this._propertyFlags & 0x800) != 0) {
                this._priority = buffer.get();
            }
            if ((this._propertyFlags & 0x400) != 0) {
                this._correlationId = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x200) != 0) {
                this._replyTo = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x100) != 0) {
                this._expiration = EncodingUtils.readLongAsShortString(buffer);
            }
            if ((this._propertyFlags & 0x80) != 0) {
                this._messageId = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x40) != 0) {
                this._timestamp = EncodingUtils.readTimestamp(buffer);
            }
            if ((this._propertyFlags & 0x20) != 0) {
                this._type = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 0x10) != 0) {
                this._userId = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 8) != 0) {
                this._appId = EncodingUtils.readAMQShortString(buffer);
            }
            if ((this._propertyFlags & 4) != 0) {
                this._clusterId = EncodingUtils.readAMQShortString(buffer);
            }
        }
        catch (AMQFrameDecodingException e) {
            throw new RuntimeException("Error in content header data: " + e, e);
        }
        int endPos = buffer.position();
        buffer.position(pos);
        int len = endPos - pos;
        this._encodedForm = new byte[len];
        int limit = buffer.limit();
        buffer.limit(endPos);
        buffer.get(this._encodedForm, 0, len);
        buffer.limit(limit);
        buffer.position(endPos);
        this._decoded = true;
    }

    private void decodeUpToHeaders() {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])this._encodedForm);
        try {
            byte length;
            if ((this._propertyFlags & 0x8000) != 0) {
                length = buffer.get();
                buffer.skip((int)length);
            }
            if ((this._propertyFlags & 0x4000) != 0) {
                length = buffer.get();
                buffer.skip((int)length);
            }
            if ((this._propertyFlags & 0x2000) != 0) {
                this._headers = EncodingUtils.readFieldTable(buffer);
            }
            this._decodedHeaders = true;
        }
        catch (AMQFrameDecodingException e) {
            throw new RuntimeException("Error in content header data: " + e, e);
        }
    }

    private void decodeUpToContentType() {
        ByteBuffer buffer = ByteBuffer.wrap((byte[])this._encodedForm);
        if ((this._propertyFlags & 0x8000) != 0) {
            this._contentType = EncodingUtils.readAMQShortString(buffer);
        }
        this._decodedContentType = true;
    }

    private void decodeIfNecessary() {
        if (!this._decoded) {
            // empty if block
        }
    }

    private void decodeHeadersIfNecessary() {
        if (!this._decoded && !this._decodedHeaders) {
            this.decodeUpToHeaders();
        }
    }

    private void decodeContentTypeIfNecessary() {
        if (!this._decoded && !this._decodedContentType) {
            this.decodeUpToContentType();
        }
    }

    public AMQShortString getContentType() {
        this.decodeContentTypeIfNecessary();
        return this._contentType;
    }

    public String getContentTypeAsString() {
        this.decodeContentTypeIfNecessary();
        return this._contentType == null ? null : this._contentType.toString();
    }

    public void setContentType(AMQShortString contentType) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x8000;
        this._contentType = contentType;
    }

    public void setContentType(String contentType) {
        this._hasBeenUpdated = true;
        this.setContentType(contentType == null ? null : new AMQShortString(contentType));
    }

    public String getEncodingAsString() {
        return this.getEncoding() == null ? null : this.getEncoding().toString();
    }

    public AMQShortString getEncoding() {
        this.decodeIfNecessary();
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x4000;
        this._encoding = encoding == null ? null : new AMQShortString(encoding);
    }

    public void setEncoding(AMQShortString encoding) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x4000;
        this._encoding = encoding;
    }

    public FieldTable getHeaders() {
        this.decodeHeadersIfNecessary();
        if (this._headers == null) {
            this.setHeaders(FieldTableFactory.newFieldTable());
        }
        return this._headers;
    }

    public void setHeaders(FieldTable headers) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x2000;
        this._headers = headers;
    }

    public byte getDeliveryMode() {
        this.decodeIfNecessary();
        return this._deliveryMode;
    }

    public void setDeliveryMode(byte deliveryMode) {
        this.clearEncodedForm();
        this._propertyFlags |= 0x1000;
        this._deliveryMode = deliveryMode;
    }

    public byte getPriority() {
        this.decodeIfNecessary();
        return this._priority;
    }

    public void setPriority(byte priority) {
        this.clearEncodedForm();
        this._propertyFlags |= 0x800;
        this._priority = priority;
    }

    public AMQShortString getCorrelationId() {
        this.decodeIfNecessary();
        return this._correlationId;
    }

    public String getCorrelationIdAsString() {
        this.decodeIfNecessary();
        return this._correlationId == null ? null : this._correlationId.toString();
    }

    public void setCorrelationId(String correlationId) {
        this._hasBeenUpdated = true;
        this.setCorrelationId(correlationId == null ? null : new AMQShortString(correlationId));
    }

    public void setCorrelationId(AMQShortString correlationId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x400;
        this._correlationId = correlationId;
    }

    public String getReplyToAsString() {
        this.decodeIfNecessary();
        return this._replyTo == null ? null : this._replyTo.toString();
    }

    public AMQShortString getReplyTo() {
        this.decodeIfNecessary();
        return this._replyTo;
    }

    public void setReplyTo(String replyTo) {
        this._hasBeenUpdated = true;
        this.setReplyTo(replyTo == null ? null : new AMQShortString(replyTo));
    }

    public void setReplyTo(AMQShortString replyTo) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x200;
        this._replyTo = replyTo;
    }

    public long getExpiration() {
        this.decodeIfNecessary();
        return this._expiration;
    }

    public void setExpiration(long expiration) {
        this.clearEncodedForm();
        this._propertyFlags |= 0x100;
        this._expiration = expiration;
    }

    public AMQShortString getMessageId() {
        this.decodeIfNecessary();
        return this._messageId;
    }

    public String getMessageIdAsString() {
        this.decodeIfNecessary();
        return this._messageId == null ? null : this._messageId.toString();
    }

    public void setMessageId(String messageId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x80;
        this._messageId = messageId == null ? null : new AMQShortString(messageId);
    }

    public void setMessageId(AMQShortString messageId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x80;
        this._messageId = messageId;
    }

    public long getTimestamp() {
        this.decodeIfNecessary();
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.clearEncodedForm();
        this._propertyFlags |= 0x40;
        this._timestamp = timestamp;
    }

    public String getTypeAsString() {
        this.decodeIfNecessary();
        return this._type == null ? null : this._type.toString();
    }

    public AMQShortString getType() {
        this.decodeIfNecessary();
        return this._type;
    }

    public void setType(String type) {
        this._hasBeenUpdated = true;
        this.setType(type == null ? null : new AMQShortString(type));
    }

    public void setType(AMQShortString type) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x20;
        this._type = type;
    }

    public String getUserIdAsString() {
        this.decodeIfNecessary();
        return this._userId == null ? null : this._userId.toString();
    }

    public AMQShortString getUserId() {
        this.decodeIfNecessary();
        return this._userId;
    }

    public void setUserId(String userId) {
        this.setUserId(userId == null ? null : new AMQShortString(userId));
    }

    public void setUserId(AMQShortString userId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 0x10;
        this._userId = userId;
    }

    public String getAppIdAsString() {
        this.decodeIfNecessary();
        return this._appId == null ? null : this._appId.toString();
    }

    public AMQShortString getAppId() {
        this.decodeIfNecessary();
        return this._appId;
    }

    public void setAppId(String appId) {
        this._hasBeenUpdated = true;
        this.setAppId(appId == null ? null : new AMQShortString(appId));
    }

    public void setAppId(AMQShortString appId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 8;
        this._appId = appId;
        this._hasBeenUpdated = true;
    }

    public String getClusterIdAsString() {
        this._hasBeenUpdated = true;
        this.decodeIfNecessary();
        return this._clusterId == null ? null : this._clusterId.toString();
    }

    public AMQShortString getClusterId() {
        this._hasBeenUpdated = true;
        this.decodeIfNecessary();
        return this._clusterId;
    }

    public void setClusterId(String clusterId) {
        this._hasBeenUpdated = true;
        this.setClusterId(clusterId == null ? null : new AMQShortString(clusterId));
    }

    public void setClusterId(AMQShortString clusterId) {
        this._hasBeenUpdated = true;
        this.clearEncodedForm();
        this._propertyFlags |= 4;
        this._clusterId = clusterId;
    }

    public String toString() {
        return "reply-to = " + this._replyTo + ",propertyFlags = " + this._propertyFlags + ",ApplicationID = " + this._appId + ",ClusterID = " + this._clusterId + ",UserId = " + this._userId + ",JMSMessageID = " + this._messageId + ",JMSCorrelationID = " + this._correlationId + ",JMSDeliveryMode = " + this._deliveryMode + ",JMSExpiration = " + this._expiration + ",JMSPriority = " + this._priority + ",JMSTimestamp = " + this._timestamp + ",JMSType = " + this._type;
    }
}

