/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQBody;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;

public class ContentBody
implements AMQBody {
    public static final byte TYPE = 3;
    public ByteBuffer payload;

    public ContentBody() {
    }

    public ContentBody(ByteBuffer buffer, long size) throws AMQFrameDecodingException {
        if (size > 0L) {
            this.payload = buffer.slice();
            this.payload.limit((int)size);
            buffer.skip((int)size);
        }
    }

    public ContentBody(ByteBuffer payload) {
        this.payload = payload;
    }

    public byte getFrameType() {
        return 3;
    }

    public int getSize() {
        return this.payload == null ? 0 : this.payload.limit();
    }

    public void writePayload(ByteBuffer buffer) {
        if (this.payload != null) {
            if (this.payload.isDirect() || this.payload.isReadOnly()) {
                ByteBuffer copy = this.payload.duplicate();
                buffer.put(copy.rewind());
            } else {
                buffer.put(this.payload.array(), this.payload.arrayOffset(), this.payload.limit());
            }
        }
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.contentBodyReceived(channelId, this);
    }

    protected void populateFromBuffer(ByteBuffer buffer, long size) throws AMQFrameDecodingException {
        if (size > 0L) {
            this.payload = buffer.slice();
            this.payload.limit((int)size);
            buffer.skip((int)size);
        }
    }

    public void reduceBufferToFit() {
        if (this.payload != null && this.payload.remaining() < this.payload.capacity() / 2) {
            int size = this.payload.limit();
            ByteBuffer newPayload = ByteBuffer.allocate((int)size);
            newPayload.put(this.payload);
            newPayload.flip();
            this.payload.release();
            this.payload = newPayload;
        }
    }

    public static AMQFrame createAMQFrame(int channelId, ContentBody body) {
        AMQFrame frame = new AMQFrame(channelId, body);
        return frame;
    }
}

