/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndesExecuter {
    private static Log log = LogFactory.getLog(AndesExecuter.class);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("AndesExecutor-%d").build();
    private static ExecutorService executorService = null;
    private static volatile AndesExecuter INSTANCE;
    private static ExecutorService genricExecutorService;

    private AndesExecuter() {
    }

    private AndesExecuter(int poolSize) {
        executorService = Executors.newFixedThreadPool(poolSize, namedThreadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AndesExecuter getInstance(int poolSize) {
        if (INSTANCE != null) return INSTANCE;
        Class<AndesExecuter> clazz = AndesExecuter.class;
        synchronized (AndesExecuter.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AndesExecuter(poolSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Future<?> submit(Runnable job, String channelId) {
        return executorService.submit(job);
    }

    public static void runAsync(Runnable runnable) {
        genricExecutorService.submit(runnable);
    }

    static {
        if (isDebugEnabled) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int workqueueSize = ((ThreadPoolExecutor)executorService).getQueue().size();
                                log.debug((Object)("AndesExecuter pool queue size " + workqueueSize));
                                Thread.sleep(30000L);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }
        genricExecutorService = Executors.newFixedThreadPool(100, namedThreadFactory);
    }
}

