/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;

public class SSLContextFactory {
    private String _keyStorePath;
    private String _keyStorePassword;
    private String _keyStoreCertType;
    private String _trustStorePath;
    private String _trustStorePassword;
    private String _trustStoreCertType;
    private KeyManager customKeyManager;

    public SSLContextFactory(String trustStorePath, String trustStorePassword, String trustStoreCertType) {
        this(trustStorePath, trustStorePassword, trustStoreCertType, trustStorePath, trustStorePassword, trustStoreCertType);
    }

    public SSLContextFactory(String trustStorePath, String trustStorePassword, String trustStoreCertType, String keyStorePath, String keyStorePassword, String keyStoreCertType) {
        this._trustStorePath = trustStorePath;
        this._trustStorePassword = trustStorePassword;
        if (this._trustStorePassword != null && this._trustStorePassword.equals("none")) {
            this._trustStorePassword = null;
        }
        this._trustStoreCertType = trustStoreCertType;
        this._keyStorePath = keyStorePath;
        this._keyStorePassword = keyStorePassword;
        if (this._keyStorePassword != null && this._keyStorePassword.equals("none")) {
            this._keyStorePassword = null;
        }
        this._keyStoreCertType = keyStoreCertType;
        if (this._trustStorePath == null) {
            throw new IllegalArgumentException("A TrustStore path or KeyStore path must be specified");
        }
        if (this._trustStoreCertType == null) {
            throw new IllegalArgumentException("Cert type must be specified");
        }
    }

    public SSLContextFactory(String trustStorePath, String trustStorePassword, String trustStoreCertType, KeyManager customKeyManager) {
        this._trustStorePath = trustStorePath;
        this._trustStorePassword = trustStorePassword;
        if (this._trustStorePassword != null && this._trustStorePassword.equals("none")) {
            this._trustStorePassword = null;
        }
        this._trustStoreCertType = trustStoreCertType;
        if (this._trustStorePath == null) {
            throw new IllegalArgumentException("A TrustStore path or KeyStore path must be specified");
        }
        if (this._trustStoreCertType == null) {
            throw new IllegalArgumentException("Cert type must be specified");
        }
        this.customKeyManager = customKeyManager;
    }

    public SSLContext buildServerContext() throws GeneralSecurityException, IOException {
        KeyStore ts = SSLUtil.getInitializedKeyStore(this._trustStorePath, this._trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this._trustStoreCertType);
        tmf.init(ts);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        if (this.customKeyManager != null) {
            sslContext.init(new KeyManager[]{this.customKeyManager}, tmf.getTrustManagers(), null);
        } else {
            KeyStore ks = SSLUtil.getInitializedKeyStore(this._keyStorePath, this._keyStorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyStoreCertType);
            kmf.init(ks, this._keyStorePassword.toCharArray());
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        return sslContext;
    }

    public SSLContext buildClientContext() throws GeneralSecurityException, IOException {
        KeyStore ks = SSLUtil.getInitializedKeyStore(this._trustStorePath, this._trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this._trustStoreCertType);
        tmf.init(ks);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
        return context;
    }
}

