/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.AuthenticationHelper;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.util.AxisUtils;
import org.apache.ode.axis2.util.ClusterUrlTransformer;
import org.apache.ode.axis2.util.SoapMessageConverter;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.Properties;
import org.apache.ode.utils.WatchDog;
import org.apache.ode.utils.uuid.UUID;
import org.apache.ode.utils.wsdl.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapExternalService
implements ExternalService {
    private static final Log __log = LogFactory.getLog(ExternalService.class);
    private static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    private static ThreadLocal<ServiceClient> _cachedClients = new ThreadLocal();
    private WatchDog<Map, OptionsObserver> _axisOptionsWatchDog;
    private WatchDog<Long, ServiceFileObserver> _axisServiceWatchDog;
    private ConfigurationContext _configContext;
    private ExecutorService _executorService;
    private Definition _definition;
    private QName _serviceName;
    private String _portName;
    protected WSAEndpoint endpointReference;
    private AxisConfiguration _axisConfig;
    private SoapMessageConverter _converter;
    private Scheduler _sched;
    private BpelServer _server;
    private ProcessConf _pconf;
    private ClusterUrlTransformer _clusterUrlTransformer;
    private String endpointUrl;

    public SoapExternalService(ProcessConf pconf, QName serviceName, String portName, ExecutorService executorService, AxisConfiguration axisConfig, Scheduler sched, BpelServer server, MultiThreadedHttpConnectionManager connManager, ClusterUrlTransformer clusterUrlTransformer) throws AxisFault {
        this._definition = pconf.getDefinitionForService(serviceName);
        this._serviceName = serviceName;
        this._portName = portName;
        this._executorService = executorService;
        this._axisConfig = axisConfig;
        this._sched = sched;
        this._converter = new SoapMessageConverter(this._definition, serviceName, portName);
        this._server = server;
        this._pconf = pconf;
        this._clusterUrlTransformer = clusterUrlTransformer;
        File fileToWatch = new File(this._pconf.getBaseURI().resolve(this._serviceName.getLocalPart() + ".axis2"));
        this._axisServiceWatchDog = WatchDog.watchFile((File)fileToWatch, (WatchDog.Observer)new ServiceFileObserver(fileToWatch));
        this._axisOptionsWatchDog = new WatchDog((WatchDog.Mutable)new EndpointPropertiesMutable(), (WatchDog.Observer)new OptionsObserver());
        this._configContext = new ConfigurationContext(this._axisConfig);
        this._configContext.setProperty("MUTTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
        this._configContext.setProperty("REUSE_HTTP_CLIENT", (Object)"false");
        Element eprElmt = ODEService.genEPRfromWSDL(this._definition, serviceName, portName);
        if (eprElmt == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)ODEService.createServiceRef(eprElmt));
        this.endpointUrl = this.endpointReference.getUrl();
    }

    public void invoke(final PartnerRoleMessageExchange odeMex) {
        boolean isTwoWay = odeMex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        try {
            ServiceClient client = this.getServiceClient();
            final MessageContext mctx = new MessageContext();
            mctx.getOptions().setParent(client.getOptions());
            this.writeHeader(mctx, odeMex);
            this._converter.createSoapRequest(mctx, odeMex.getRequest(), odeMex.getOperation());
            SOAPEnvelope soapEnv = mctx.getEnvelope();
            String mexEndpointUrl = ((MutableEndpoint)odeMex.getEndpointReference()).getUrl();
            EndpointReference axisEPR = new EndpointReference(mexEndpointUrl);
            if (this.endpointUrl.equals(mexEndpointUrl)) {
                String address = (String)client.getOptions().getProperty("address");
                if (address != null) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Endpoint URL overridden by property files. " + mexEndpointUrl + " => " + address));
                    }
                    axisEPR.setAddress(address);
                }
            } else if (__log.isDebugEnabled()) {
                __log.debug((Object)("Endpoint URL overridden by process. " + this.endpointUrl + " => " + mexEndpointUrl));
            }
            axisEPR.setAddress(this._clusterUrlTransformer.rewriteOutgoingClusterURL(axisEPR.getAddress()));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Axis2 sending message to " + axisEPR.getAddress() + " using MEX " + odeMex));
                __log.debug((Object)("Message: " + soapEnv));
            }
            final OperationClient operationClient = client.createClient(isTwoWay ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
            operationClient.addMessageContext(mctx);
            Options operationOptions = operationClient.getOptions();
            AuthenticationHelper.setHttpAuthentication(odeMex, operationOptions);
            operationOptions.setAction(mctx.getSoapAction());
            operationOptions.setTo(axisEPR);
            if (isTwoWay) {
                final String mexId = odeMex.getMessageExchangeId();
                final Operation operation = odeMex.getOperation();
                this._sched.registerSynchronizer(new Scheduler.Synchronizer(){

                    public void afterCompletion(boolean success) {
                        if (!success) {
                            return;
                        }
                        SoapExternalService.this._executorService.submit(new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                try {
                                    operationClient.execute(true);
                                    MessageContext response = operationClient.getMessageContext("In");
                                    MessageContext flt = operationClient.getMessageContext("Fault");
                                    if (response != null && __log.isDebugEnabled()) {
                                        __log.debug((Object)("Service response:\n" + response.getEnvelope().toString()));
                                    }
                                    if (flt != null) {
                                        SoapExternalService.this.reply(mexId, operation, flt, true);
                                    } else {
                                        SoapExternalService.this.reply(mexId, operation, response, response.isFault());
                                    }
                                }
                                catch (Throwable t) {
                                    String errmsg = "Error sending message (mex=" + odeMex + "): " + t.getMessage();
                                    __log.error((Object)errmsg, t);
                                    SoapExternalService.this.replyWithFailure(mexId, MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg);
                                }
                                finally {
                                    TransportOutDescription out = mctx.getTransportOut();
                                    if (out != null && out.getSender() != null) {
                                        out.getSender().cleanup(mctx);
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    public void beforeCompletion() {
                    }
                });
                odeMex.replyAsync();
            } else {
                this._executorService.submit(new Callable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        try {
                            operationClient.execute(true);
                        }
                        catch (Throwable t) {
                            String errmsg = "Error sending message (mex=" + odeMex + "): " + t.getMessage();
                            __log.error((Object)errmsg, t);
                        }
                        finally {
                            TransportOutDescription out = mctx.getTransportOut();
                            if (out != null && out.getSender() != null) {
                                out.getSender().cleanup(mctx);
                            }
                        }
                        return null;
                    }
                });
                odeMex.replyOneWayOk();
            }
        }
        catch (Throwable t) {
            String errmsg = "Error sending message to Axis2 for ODE mex " + odeMex;
            __log.error((Object)errmsg, t);
            odeMex.replyWithFailure(MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceClient getServiceClient() throws AxisFault {
        try {
            this._axisServiceWatchDog.check();
            this._axisOptionsWatchDog.check();
        }
        catch (RuntimeException e) {
            throw AxisFault.makeFault((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
        AxisService anonymousService = (AxisService)((ServiceFileObserver)this._axisServiceWatchDog.getObserver()).get();
        ServiceClient client = _cachedClients.get();
        if (client == null || !client.getAxisService().getName().equals(anonymousService.getName())) {
            AxisConfiguration axisConfiguration = this._axisConfig;
            synchronized (axisConfiguration) {
                if (client != null) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)"Clean up and discard ServiceClient");
                    }
                    client.cleanup();
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Create a new ServiceClient for " + anonymousService.getName()));
                }
                client = new ServiceClient(this._configContext, null);
                client.setAxisService(anonymousService);
            }
            _cachedClients.set(client);
        }
        client.setOptions((Options)((OptionsObserver)this._axisOptionsWatchDog.getObserver()).get());
        return client;
    }

    private void applySecurityPolicy(Options options) {
        if (options != null && options.getProperty("security.policy.file") != null) {
            String policy = (String)options.getProperty("security.policy.file");
            AxisService service = (AxisService)((ServiceFileObserver)this._axisServiceWatchDog.getObserver()).get();
            AxisUtils.applySecurityPolicy(service, policy);
        }
    }

    private String getAction(String operation) {
        String action = this._converter.getWSAInputAction(operation);
        if (action == null || "".equals(action)) {
            action = this._converter.getSoapAction(operation);
        }
        return action;
    }

    private void writeHeader(MessageContext ctxt, PartnerRoleMessageExchange odeMex) {
        Options options = ctxt.getOptions();
        WSAEndpoint targetWSAEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getEndpointReference()));
        WSAEndpoint myRoleWSAEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getMyRoleEndpointReference()));
        WSAEndpoint targetEPR = new WSAEndpoint(targetWSAEPR);
        EndpointReference replyEPR = null;
        String partnerSessionId = odeMex.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        String myRoleSessionId = odeMex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (partnerSessionId != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Partner session identifier found for WSA endpoint: " + partnerSessionId));
            }
            targetEPR.setSessionId(partnerSessionId);
        }
        options.setProperty("targetSessionEndpoint", (Object)targetEPR);
        if (myRoleWSAEPR != null) {
            WSAEndpoint myRoleEPR = new WSAEndpoint(myRoleWSAEPR);
            if (myRoleSessionId != null) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MyRole session identifier found for myrole (callback) WSA endpoint: " + myRoleSessionId));
                }
                myRoleEPR.setSessionId(myRoleSessionId);
            }
            options.setProperty("callbackSessionEndpoint", (Object)myRoleEPR);
            Document callbackEprXml = odeMex.getMyRoleEndpointReference().toXML();
            Element serviceElement = callbackEprXml.getDocumentElement();
            if (myRoleSessionId != null) {
                options.setProperty("JMS_COORELATION_ID", (Object)myRoleSessionId);
            } else if (myRoleWSAEPR.getSessionId() != null) {
                options.setProperty("JMS_COORELATION_ID", (Object)myRoleSessionId);
            }
            Element address = DOMUtils.findChildByName((Element)serviceElement, (QName)new QName(Namespaces.WS_ADDRESSING_NS, "Address"), (boolean)true);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("The system-defined wsa address is : " + address));
            }
            if (address != null) {
                String url = address.getTextContent();
                String jmsDestination = (String)options.getProperty("transport.jms.ReplyDestination");
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("The user-defined JMS replyTo destination is: " + jmsDestination));
                    __log.debug((Object)("The user-defined JMS wait timeout is: " + options.getProperty("JMS_WAIT_REPLY")));
                }
                if (jmsDestination == null || "".equals(jmsDestination.trim())) {
                    int startIndex = url.indexOf("jms:/");
                    if (startIndex != -1) {
                        int jmsEndIndex;
                        if (url.charAt((startIndex += "jms:/".length()) + 1) == '/') {
                            ++startIndex;
                        }
                        if (url.startsWith("dynamic")) {
                            startIndex += "dynamicQueues".length();
                        }
                        if ((jmsEndIndex = url.indexOf("?", startIndex)) == -1) {
                            jmsEndIndex = url.length();
                        }
                        jmsDestination = url.substring(startIndex, jmsEndIndex);
                        options.setProperty("transport.jms.ReplyDestination", (Object)jmsDestination);
                    } else {
                        startIndex = url.indexOf("http://");
                        if (startIndex != -1 && (startIndex = url.indexOf("/processes/")) != -1) {
                            jmsDestination = url.substring(startIndex += "/processes/".length());
                            options.setProperty("transport.jms.ReplyDestination", (Object)jmsDestination);
                        }
                    }
                }
            }
        } else {
            __log.debug((Object)"My-Role EPR not specified, SEP will not be used.");
        }
        String action = this.getAction(odeMex.getOperationName());
        ctxt.setSoapAction(action);
        if (replyEPR == null && MessageExchange.MessageExchangePattern.REQUEST_RESPONSE == odeMex.getMessageExchangePattern()) {
            replyEPR = new EndpointReference(Namespaces.WS_ADDRESSING_ANON_URI);
        }
        if (replyEPR != null) {
            ctxt.setReplyTo(replyEPR);
            ctxt.setMessageID("uuid:" + new UUID().toString());
        }
    }

    public org.apache.ode.bpel.iapi.EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void close() {
    }

    public String getPortName() {
        return this._portName;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    private void replyWithFailure(final String odeMexId, final MessageExchange.FailureType error, final String errmsg) {
        try {
            this._sched.execTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)SoapExternalService.this._server.getEngine().getMessageExchange(odeMexId);
                    odeMex.replyWithFailure(error, errmsg, null);
                    return null;
                }
            });
        }
        catch (Exception e) {
            String emsg = "Error executing replyWithFailure transaction; reply will be lost.";
            __log.error((Object)emsg, (Throwable)e);
        }
    }

    private void reply(final String odeMexId, final Operation operation, final MessageContext reply, final boolean isFault) {
        try {
            this._sched.execTransaction((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    PartnerRoleMessageExchange odeMex = (PartnerRoleMessageExchange)SoapExternalService.this._server.getEngine().getMessageExchange(odeMexId);
                    try {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Received response for MEX " + odeMex));
                        }
                        if (isFault) {
                            Document odeMsg = DOMUtils.newDocument();
                            Element odeMsgEl = odeMsg.createElementNS(null, "message");
                            odeMsg.appendChild(odeMsgEl);
                            Fault fault = SoapExternalService.this._converter.parseSoapFault(odeMsgEl, reply.getEnvelope(), operation);
                            if (fault != null) {
                                if (__log.isWarnEnabled()) {
                                    __log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMUtils.domToString((Node)odeMsgEl)));
                                }
                                QName faultType = fault.getMessage().getQName();
                                QName faultName = new QName(SoapExternalService.this._definition.getTargetNamespace(), fault.getName());
                                Message response = odeMex.createMessage(faultType);
                                response.setMessage(odeMsgEl);
                                odeMex.replyWithFault(faultName, response);
                            } else {
                                if (__log.isWarnEnabled()) {
                                    __log.warn((Object)("Fault response: faultType=(unkown)\n" + reply.getEnvelope().toString()));
                                }
                                odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, reply.getEnvelope().getBody().getFault().getText(), OMUtils.toDOM((OMElement)reply.getEnvelope().getBody()));
                            }
                        } else {
                            Message response = odeMex.createMessage(odeMex.getOperation().getOutput().getMessage().getQName());
                            SoapExternalService.this._converter.parseSoapResponse(response, reply.getEnvelope(), operation);
                            if (__log.isInfoEnabled()) {
                                __log.info((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                            }
                            odeMex.reply(response);
                        }
                    }
                    catch (Exception ex) {
                        String errmsg = "Unable to process response: " + ex.getMessage();
                        __log.error((Object)errmsg, (Throwable)ex);
                        odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errmsg = "Error executing reply transaction; reply will be lost.";
            __log.error((Object)errmsg, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndpointPropertiesMutable
    implements WatchDog.Mutable<Map> {
        private EndpointPropertiesMutable() {
        }

        public boolean exists() {
            return true;
        }

        public boolean hasChangedSince(Map since) {
            Map latest = this.lastModified();
            return !CollectionUtils.equals((Map)latest, (Map)since);
        }

        public Map lastModified() {
            return SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
        }

        public String toString() {
            return "Properties for Endpoint: " + SoapExternalService.this._serviceName + "#" + SoapExternalService.this._portName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionsObserver
    extends WatchDog.DefaultObserver<Options> {
        private OptionsObserver() {
        }

        public void init() {
            this.object = new Options();
            ((Options)this.object).setExceptionToBeThrownOnSOAPFault(false);
            ((Options)this.object).setTimeOutInMilliSeconds(60000L);
        }

        public void onUpdate() {
            this.init();
            Map properties = SoapExternalService.this._pconf.getEndpointProperties((org.apache.ode.bpel.iapi.EndpointReference)SoapExternalService.this.endpointReference);
            Properties.Axis2.translate((Map)properties, (Options)((Options)this.object));
            SoapExternalService.this.applySecurityPolicy((Options)this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServiceFileObserver
    extends WatchDog.DefaultObserver<AxisService> {
        File file;

        private ServiceFileObserver(File file) {
            this.file = file;
        }

        public void init() {
            String serviceName = "axis_service_for_" + SoapExternalService.this._serviceName + "#" + SoapExternalService.this._portName + "_" + new GUID().toString();
            this.object = new AxisService(serviceName);
            ((AxisService)this.object).setParent((AxisDescription)SoapExternalService.this._axisConfig);
            OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
            ((AxisService)this.object).addOperation((AxisOperation)outOnlyOperation);
            OutInAxisOperation outInOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
            ((AxisService)this.object).addOperation((AxisOperation)outInOperation);
            outOnlyOperation.setSoapAction("");
            outInOperation.setSoapAction("");
        }

        public void onUpdate() {
            this.init();
            try {
                String name = ((AxisService)this.object).getName();
                AxisUtils.configureService(SoapExternalService.this._configContext, (AxisService)this.object, this.file.toURI().toURL());
                ((AxisService)this.object).setName(name);
            }
            catch (Exception e) {
                if (__log.isWarnEnabled()) {
                    __log.warn((Object)("Exception while configuring service: " + SoapExternalService.this._serviceName), (Throwable)e);
                }
                throw new RuntimeException("Exception while configuring service: " + SoapExternalService.this._serviceName, e);
            }
            Options options = (Options)((OptionsObserver)SoapExternalService.this._axisOptionsWatchDog.getObserver()).get();
            SoapExternalService.this.applySecurityPolicy(options);
        }
    }
}

