/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.HttpHelper;
import org.apache.ode.axis2.util.URLEncodedTransformer;
import org.apache.ode.axis2.util.UrlReplacementTransformer;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.http.HttpUtils;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodConverter {
    private static final Log log = LogFactory.getLog(HttpMethodConverter.class);
    protected static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    protected Definition definition;
    protected Binding binding;
    protected QName serviceName;
    protected String portName;

    public HttpMethodConverter(Definition definition, QName serviceName, String portName) {
        this.definition = definition;
        this.binding = definition.getService(serviceName).getPort(portName).getBinding();
        this.serviceName = serviceName;
        this.portName = portName;
    }

    public HttpMethod createHttpRequest(PartnerRoleMessageExchange odeMex, HttpParams params) throws UnsupportedEncodingException {
        return this.createHttpRequest(odeMex, params, ((MutableEndpoint)odeMex.getEndpointReference()).getUrl());
    }

    public HttpMethod createHttpRequest(PartnerRoleMessageExchange odeMex, HttpParams params, String baseUrl) throws UnsupportedEncodingException {
        Operation operation = odeMex.getOperation();
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        Element message = odeMex.getRequest().getMessage();
        Message msgDef = operation.getInput().getMessage();
        Map<String, Element> partElements = this.extractPartElements(msgDef, message);
        String verb = WsdlUtils.resolveVerb((Binding)this.binding, (BindingOperation)bindingOperation);
        HttpMethod method = this.prepareHttpMethod(bindingOperation, verb, partElements, odeMex.getRequest().getHeaderParts(), baseUrl, params);
        return method;
    }

    protected HttpMethod prepareHttpMethod(BindingOperation opBinding, String verb, Map<String, Element> partValues, Map<String, Node> headers, String rootUri, HttpParams params) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing http request...");
        }
        BindingInput bindingInput = opBinding.getBindingInput();
        HTTPOperation httpOperation = (HTTPOperation)WsdlUtils.getOperationExtension((BindingOperation)opBinding);
        MIMEContent content = WsdlUtils.getMimeContent((List)bindingInput.getExtensibilityElements());
        String contentType = content == null ? null : content.getType();
        boolean useUrlEncoded = WsdlUtils.useUrlEncoded((BindingInput)bindingInput) || "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
        boolean useUrlReplacement = WsdlUtils.useUrlReplacement((BindingInput)bindingInput);
        GetMethod method = null;
        String relativeUri = httpOperation.getLocationURI();
        String queryPath = null;
        String encodedParams = null;
        String completeUri = rootUri;
        if (StringUtils.isNotEmpty((String)relativeUri)) {
            completeUri = completeUri + (completeUri.endsWith("/") || relativeUri.startsWith("/") ? "" : "/") + relativeUri;
        }
        if (useUrlReplacement) {
            completeUri = new UrlReplacementTransformer().transform(completeUri, partValues);
        } else if (useUrlEncoded) {
            encodedParams = new URLEncodedTransformer().transform(partValues);
        }
        if ("GET".equalsIgnoreCase(verb) || "DELETE".equalsIgnoreCase(verb)) {
            if ("GET".equalsIgnoreCase(verb)) {
                method = new GetMethod();
            } else if ("DELETE".equalsIgnoreCase(verb)) {
                method = new DeleteMethod();
            }
            method.getParams().setDefaults(params);
            if (useUrlEncoded) {
                queryPath = encodedParams;
            }
            method.setFollowRedirects(true);
        } else if ("POST".equalsIgnoreCase(verb) || "PUT".equalsIgnoreCase(verb)) {
            StringRequestEntity requestEntity;
            if ("POST".equalsIgnoreCase(verb)) {
                method = new PostMethod();
            } else if ("PUT".equalsIgnoreCase(verb)) {
                method = new PutMethod();
            }
            method.getParams().setDefaults(params);
            String contentCharset = method.getParams().getContentCharset();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Content-Type [" + contentType + "] Charset [" + contentCharset + "]"));
            }
            if (useUrlEncoded) {
                requestEntity = new StringRequestEntity(encodedParams, "application/x-www-form-urlencoded", contentCharset);
            } else {
                Part part = opBinding.getOperation().getInput().getMessage().getPart(content.getPart());
                Element partValue = partValues.get(part.getName());
                if (part.getElementName() == null) {
                    String errMsg = "XML Types are not supported. Parts must use elements.";
                    if (log.isErrorEnabled()) {
                        log.error((Object)errMsg);
                    }
                    throw new RuntimeException(errMsg);
                }
                if (HttpUtils.isXml((String)contentType)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Content-Type [" + contentType + "] equivalent to 'text/xml'"));
                    }
                    String xmlString = DOMUtils.domToString((Node)DOMUtils.getFirstChildElement((Element)partValue));
                    requestEntity = new StringRequestEntity(xmlString, contentType, contentCharset);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Content-Type [" + contentType + "] NOT equivalent to 'text/xml'. The text content of part value will be sent as text"));
                    }
                    requestEntity = new StringRequestEntity(DOMUtils.getTextContent((Node)partValue), contentType, contentCharset);
                }
            }
            EntityEnclosingMethod enclosingMethod = (EntityEnclosingMethod)method;
            enclosingMethod.setRequestEntity((RequestEntity)requestEntity);
            enclosingMethod.setContentChunked(params.getBooleanParameter("http.request.chunk", false));
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + verb);
        }
        method.setPath(completeUri);
        method.setQueryString(queryPath);
        this.setHttpRequestHeaders((HttpMethod)method, opBinding, partValues, headers, params);
        return method;
    }

    public void setHttpRequestHeaders(HttpMethod method, BindingOperation opBinding, Map<String, Element> partValues, Map<String, Node> headers, HttpParams params) {
        BindingInput inputBinding = opBinding.getBindingInput();
        Message inputMessage = opBinding.getOperation().getInput().getMessage();
        Collection defaultHeaders = (Collection)params.getParameter("http.default-headers");
        if (defaultHeaders != null) {
            Iterator i = defaultHeaders.iterator();
            while (i.hasNext()) {
                method.setRequestHeader((Header)i.next());
            }
        }
        for (Map.Entry<String, Node> e : headers.entrySet()) {
            String headerName = e.getKey();
            Node headerNode = e.getValue();
            String headerValue = DOMUtils.domToString((Node)headerNode);
            method.setRequestHeader(headerName, HttpHelper.replaceCRLFwithLWS(headerValue));
        }
        Collection headerBindings = WsdlUtils.getHttpHeaders((List)inputBinding.getExtensibilityElements());
        Iterator iterator = headerBindings.iterator();
        while (iterator.hasNext()) {
            String headerValue;
            Element binding = ((UnknownExtensibilityElement)iterator.next()).getElement();
            String headerName = binding.getAttribute("name");
            String partName = binding.getAttribute("part");
            String value = binding.getAttribute("value");
            if (StringUtils.isNotEmpty((String)partName)) {
                Part part = inputMessage.getPart(partName);
                Element partWrapper = partValues.get(part.getName());
                if (DOMUtils.isEmptyElement((Element)partWrapper)) {
                    headerValue = "";
                } else {
                    Element childElement = DOMUtils.getFirstChildElement((Element)partWrapper);
                    if (childElement != null) {
                        if (DOMUtils.getFirstChildElement((Element)childElement) != null) {
                            String errMsg = "Complex types are not supported. Header Parts must be simple types or elements of a simple type.";
                            if (log.isErrorEnabled()) {
                                log.error((Object)errMsg);
                            }
                            throw new RuntimeException(errMsg);
                        }
                        headerValue = DOMUtils.getTextContent((Node)childElement);
                    } else {
                        headerValue = DOMUtils.getTextContent((Node)partWrapper);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)value)) {
                headerValue = value;
            } else {
                String errMsg = "Invalid binding: missing attribute! Expecting " + new QName(Namespaces.ODE_HTTP_EXTENSION_NS, "part") + " or " + new QName(Namespaces.ODE_HTTP_EXTENSION_NS, "value");
                if (log.isErrorEnabled()) {
                    log.error((Object)errMsg);
                }
                throw new RuntimeException(errMsg);
            }
            if (!StringUtils.isNotEmpty((String)headerValue)) continue;
            method.setRequestHeader(headerName, HttpHelper.replaceCRLFwithLWS(headerValue));
        }
        MIMEContent outputContent = WsdlUtils.getMimeContent((List)opBinding.getBindingOutput().getExtensibilityElements());
        if (outputContent != null) {
            method.setRequestHeader("Accept", outputContent.getType());
        }
    }

    protected Map<String, Element> extractPartElements(Message msgDef, Element message) {
        if (msgDef.getParts().size() != 0 && message == null) {
            throw new IllegalArgumentException(msgs.msgOdeMessageExpected());
        }
        HashMap<String, Element> partValues = new HashMap<String, Element>();
        for (Part part : msgDef.getParts().values()) {
            Element partEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, part.getName()));
            if (partEl == null) {
                throw new IllegalArgumentException(msgs.msgOdeMessageMissingRequiredPart(part.getName()));
            }
            partValues.put(part.getName(), partEl);
        }
        return partValues;
    }

    public Element createPartElement(Part part, String textContent) {
        Document doc = DOMUtils.newDocument();
        Element partElement = doc.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            Element element = doc.createElementNS(part.getElementName().getNamespaceURI(), part.getElementName().getLocalPart());
            element.setTextContent(textContent);
            partElement.appendChild(element);
        } else {
            partElement.setTextContent(textContent);
        }
        return partElement;
    }

    public Element createPartElement(Part part, Element receivedElement) {
        Document doc = DOMUtils.newDocument();
        Element partElement = doc.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            partElement.appendChild(doc.importNode(receivedElement, true));
        } else if (DOMUtils.isEmptyElement((Element)receivedElement)) {
            partElement.appendChild(doc.createTextNode(""));
        } else {
            for (int m = 0; m < receivedElement.getChildNodes().getLength(); ++m) {
                Node child = receivedElement.getChildNodes().item(m);
                partElement.appendChild(doc.importNode(child, true));
            }
        }
        return partElement;
    }

    public void extractHttpResponseHeaders(org.apache.ode.bpel.iapi.Message odeMessage, HttpMethod method, Operation operationDef) {
        Message messageDef = operationDef.getOutput().getMessage();
        BindingOutput outputBinding = this.binding.getBindingOperation(operationDef.getName(), operationDef.getInput().getName(), operationDef.getOutput().getName()).getBindingOutput();
        Collection headerBindings = WsdlUtils.getHttpHeaders((List)outputBinding.getExtensibilityElements());
        Iterator iterator = headerBindings.iterator();
        while (iterator.hasNext()) {
            Element binding = ((UnknownExtensibilityElement)iterator.next()).getElement();
            String partName = binding.getAttribute("part");
            String headerName = binding.getAttribute("name");
            Part part = messageDef.getPart(partName);
            if (StringUtils.isNotEmpty((String)partName)) {
                Header responseHeader = method.getResponseHeader(headerName);
                if (responseHeader == null) continue;
                odeMessage.setPart(partName, this.createPartElement(part, responseHeader.getValue()));
                continue;
            }
            String errMsg = "Invalid binding: missing required attribute! Part name: " + new QName(Namespaces.ODE_HTTP_EXTENSION_NS, "part");
            if (log.isErrorEnabled()) {
                log.error((Object)errMsg);
            }
            throw new RuntimeException(errMsg);
        }
        HashSet<String> headerNames = new HashSet<String>();
        for (Header header : method.getResponseHeaders()) {
            headerNames.add(header.getName());
        }
        for (String hname : headerNames) {
            odeMessage.setHeaderPart(hname, method.getResponseHeader(hname).getValue());
        }
        odeMessage.setHeaderPart("Status-Line", HttpHelper.statusLineToElement(method.getStatusLine()));
    }

    public void parseHttpResponse(org.apache.ode.bpel.iapi.Message odeResponse, HttpMethod method, Operation opDef) throws SAXException, IOException {
        String body;
        BindingOperation opBinding = this.binding.getBindingOperation(opDef.getName(), opDef.getInput().getName(), opDef.getOutput().getName());
        this.extractHttpResponseHeaders(odeResponse, method, opDef);
        MIMEContent outputContent = WsdlUtils.getMimeContent((List)opBinding.getBindingOutput().getExtensibilityElements());
        int status = method.getStatusCode();
        boolean xmlExpected = outputContent != null && HttpUtils.isXml((String)outputContent.getType());
        boolean isBodyExpected = outputContent != null;
        boolean isBodyMandatory = isBodyExpected && HttpUtils.bodyAllowed((int)status) && status != 202;
        try {
            body = method.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the request body : " + e.getMessage());
        }
        boolean emptyBody = StringUtils.isEmpty((String)body);
        if (emptyBody) {
            if (isBodyMandatory) {
                throw new RuntimeException("Response body is mandatory but missing!");
            }
        } else if (isBodyExpected) {
            Element partElement;
            Part partDef = opDef.getOutput().getMessage().getPart(outputContent.getPart());
            if (xmlExpected) {
                boolean xmlReceived;
                Header h = method.getResponseHeader("Content-Type");
                String receivedType = h != null ? h.getValue() : null;
                boolean contentTypeSet = receivedType != null;
                boolean bl = xmlReceived = contentTypeSet && HttpUtils.isXml((String)receivedType);
                if (!contentTypeSet) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received Response with a body but no 'Content-Type' header!");
                    }
                } else if (!xmlReceived && log.isDebugEnabled()) {
                    log.debug((Object)("Xml type was expected but non-xml type received! Expected Content-Type=" + outputContent.getType() + " Received Content-Type=" + receivedType));
                }
                Element bodyElement = DOMUtils.stringToDOM((String)body);
                partElement = this.createPartElement(partDef, bodyElement);
            } else {
                partElement = this.createPartElement(partDef, body);
            }
            odeResponse.setPart(partDef.getName(), partElement);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Body received but not mapped to any part! Body=\n" + body));
        }
    }

    public Object[] parseFault(PartnerRoleMessageExchange odeMex, HttpMethod method) {
        Element bodyElement;
        String receivedType;
        String body;
        Operation opDef = odeMex.getOperation();
        BindingOperation opBinding = this.binding.getBindingOperation(opDef.getName(), opDef.getInput().getName(), opDef.getOutput().getName());
        try {
            body = method.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the request body : " + e.getMessage(), e);
        }
        Header h = method.getResponseHeader("Content-Type");
        String string = receivedType = h != null ? h.getValue() : null;
        if (opDef.getFaults().isEmpty()) {
            throw new RuntimeException("Operation [" + opDef.getName() + "] has no fault. This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        if (opBinding.getBindingFaults().isEmpty()) {
            throw new RuntimeException("No fault binding. This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        if (StringUtils.isEmpty((String)body)) {
            throw new RuntimeException("No body in the response. This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        if (receivedType != null && !HttpUtils.isXml((String)receivedType)) {
            throw new RuntimeException("Response Content-Type [" + receivedType + "] does not describe XML entities. Faults must be XML. This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        if (receivedType == null && log.isWarnEnabled()) {
            log.warn((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + opDef.getName() + "] Received Response with a body but no 'Content-Type' header! Will try to parse nevertheless."));
        }
        try {
            bodyElement = DOMUtils.stringToDOM((String)body);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse the response body as xml. This " + method.getStatusCode() + " error will be considered as a failure.", e);
        }
        QName bodyName = new QName(bodyElement.getNamespaceURI(), bodyElement.getNodeName());
        Fault faultDef = WsdlUtils.inferFault((Operation)opDef, (QName)bodyName);
        if (faultDef == null) {
            throw new RuntimeException("Unknown Fault Type [" + bodyName + "] This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        if (!WsdlUtils.isOdeFault((BindingFault)opBinding.getBindingFault(faultDef.getName()))) {
            throw new RuntimeException("Fault [" + bodyName + "] is not bound with " + new QName(Namespaces.ODE_HTTP_EXTENSION_NS, "fault") + ". This " + method.getStatusCode() + " error will be considered as a failure.");
        }
        Part partDef = (Part)faultDef.getMessage().getParts().values().iterator().next();
        QName faultName = new QName(this.definition.getTargetNamespace(), faultDef.getName());
        QName faultType = faultDef.getMessage().getQName();
        org.apache.ode.bpel.iapi.Message response = odeMex.createMessage(faultType);
        Element partElement = this.createPartElement(partDef, bodyElement);
        response.setPart(partDef.getName(), partElement);
        this.extractHttpResponseHeaders(response, method, opDef);
        return new Object[]{faultName, response};
    }
}

