/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.hooks.ODEAxisOperationDispatcher;
import org.apache.ode.axis2.hooks.ODEMessageReceiver;
import org.apache.ode.axis2.util.Axis2UriResolver;
import org.apache.ode.axis2.util.Axis2WSDLLocator;
import org.apache.ode.axis2.util.AxisUtils;
import org.apache.ode.bpel.epr.WSDL11Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;

public class ODEAxisService {
    private static final Log LOG = LogFactory.getLog(ODEAxisService.class);

    public static AxisService createService(AxisConfiguration axisConfig, ProcessConf pconf, QName wsdlServiceName, String portName) throws AxisFault {
        Definition wsdlDefinition = pconf.getDefinitionForService(wsdlServiceName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create AxisService: service=" + wsdlServiceName + " port=" + portName + " WSDL=" + wsdlDefinition.getDocumentBaseURI() + " BPEL=" + pconf.getBpelDocument()));
        }
        InputStream is = null;
        try {
            URI baseUri = pconf.getBaseURI().resolve(wsdlDefinition.getDocumentBaseURI());
            is = baseUri.toURL().openStream();
            WSDL11ToAxisPatchedBuilder serviceBuilder = new WSDL11ToAxisPatchedBuilder(is, wsdlServiceName, portName);
            serviceBuilder.setBaseUri(baseUri.toString());
            serviceBuilder.setCustomResolver(new Axis2UriResolver());
            serviceBuilder.setCustomWSLD4JResolver(new Axis2WSDLLocator(baseUri));
            serviceBuilder.setServerSide(true);
            String axisServiceName = ODEAxisService.extractServiceName(pconf, wsdlServiceName, portName);
            AxisService axisService = serviceBuilder.populateService();
            axisService.setParent((AxisDescription)axisConfig);
            axisService.setName(axisServiceName);
            axisService.setWsdlFound(true);
            axisService.setCustomWsdl(true);
            axisService.setClassLoader(axisConfig.getServiceClassLoader());
            URL wsdlUrl = null;
            for (File file : pconf.getFiles()) {
                if (file.getAbsolutePath().indexOf(wsdlDefinition.getDocumentBaseURI()) <= 0) continue;
                wsdlUrl = file.toURI().toURL();
            }
            if (wsdlUrl != null) {
                axisService.setFileName(wsdlUrl);
            }
            URL service_file = pconf.getBaseURI().resolve(wsdlServiceName.getLocalPart() + ".axis2").toURL();
            LOG.debug((Object)("Looking for Axis2 service configuration file: " + service_file));
            try {
                AxisUtils.configureService(axisService, service_file);
            }
            catch (FileNotFoundException except) {
                LOG.debug((Object)("Axis2 service configuration not found: " + service_file));
            }
            catch (IOException except) {
                LOG.warn((Object)("Exception while configuring service: " + service_file), (Throwable)except);
            }
            WSDL11Endpoint endpoint = new WSDL11Endpoint(wsdlServiceName, portName);
            Map properties = pconf.getEndpointProperties((EndpointReference)endpoint);
            if (properties.get("security.policy.file") != null) {
                AxisUtils.applySecurityPolicy(axisService, (String)properties.get("security.policy.file"));
            }
            ODEAxisService.declarePartsElements(wsdlDefinition, wsdlServiceName, axisServiceName, portName);
            Iterator operations = axisService.getOperations();
            ODEMessageReceiver msgReceiver = new ODEMessageReceiver();
            while (operations.hasNext()) {
                AxisOperation operation = (AxisOperation)operations.next();
                if (operation.getMessageReceiver() != null) continue;
                operation.setMessageReceiver((MessageReceiver)msgReceiver);
            }
            if (ODEAxisService.isJmsEndpoint(pconf, wsdlServiceName, portName)) {
                axisService.addParameter(new Parameter("transport.jms.Destination", (Object)ODEAxisService.extractJMSDestinationName(axisServiceName, ODEAxisService.deriveBaseServiceUri(pconf))));
            }
            AxisService axisService2 = axisService;
            return axisService2;
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String extractJMSDestinationName(String axisServiceName, String baseUri) {
        String destinationPrefix = "dynamicQueues/";
        int index = axisServiceName.indexOf(destinationPrefix);
        if (index == -1) {
            destinationPrefix = "dynamicTopics/";
            index = axisServiceName.indexOf(destinationPrefix);
        }
        if (index == -1) {
            destinationPrefix = baseUri + "/";
            index = axisServiceName.indexOf(destinationPrefix);
            return index != -1 ? axisServiceName.substring(destinationPrefix.length()) : axisServiceName;
        }
        return axisServiceName.substring(index);
    }

    public static AxisService createService(AxisConfiguration axisConfig, QName serviceQName, String port, String axisName, Definition wsdlDef, MessageReceiver receiver) throws AxisFault {
        WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(wsdlDef, serviceQName, port);
        AxisService axisService = serviceBuilder.populateService();
        axisService.setName(axisName);
        axisService.setWsdlFound(true);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        Iterator operations = axisService.getOperations();
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            if (operation.getMessageReceiver() != null) continue;
            operation.setMessageReceiver(receiver);
        }
        return axisService;
    }

    private static String extractEndpointUri(ProcessConf pconf, QName wsdlServiceName, String portName) throws AxisFault {
        Definition wsdlDefinition = pconf.getDefinitionForService(wsdlServiceName);
        String url = null;
        Service service = wsdlDefinition.getService(wsdlServiceName);
        if (service == null) {
            throw new OdeFault("Unable to find service " + wsdlServiceName + " from service WSDL definition " + wsdlDefinition.getDocumentBaseURI());
        }
        Port port = service.getPort(portName);
        if (port == null) {
            throw new OdeFault("Couldn't find port " + portName + " in definition " + wsdlServiceName);
        }
        for (Object oext : port.getExtensibilityElements()) {
            if (!(oext instanceof SOAPAddress)) continue;
            url = ((SOAPAddress)oext).getLocationURI();
        }
        if (url == null) {
            throw new OdeFault("Could not extract any soap:address from service WSDL definition " + wsdlServiceName + " (necessary to establish the process target address)!");
        }
        return url;
    }

    private static boolean isJmsEndpoint(ProcessConf pconf, QName wsdlServiceName, String portName) throws AxisFault {
        String url = ODEAxisService.extractEndpointUri(pconf, wsdlServiceName, portName);
        return url.startsWith("jms:");
    }

    private static String extractServiceName(ProcessConf pconf, QName wsdlServiceName, String portName) throws AxisFault {
        String derivedUri;
        String endpointUri = ODEAxisService.extractEndpointUri(pconf, wsdlServiceName, portName);
        String serviceName = ODEAxisService.parseURLForService(endpointUri, derivedUri = ODEAxisService.deriveBaseServiceUri(pconf));
        if (serviceName == null) {
            throw new OdeFault("The soap:address " + endpointUri + " used for service " + wsdlServiceName + " and port " + portName + " should be of the form http://hostname:port/ode/processes/myProcessEndpointName");
        }
        return serviceName;
    }

    protected static String parseURLForService(String path, String baseUri) {
        int index;
        String servicePrefix = "/processes/";
        if (path.startsWith("jms:/")) {
            servicePrefix = "jms:/";
        }
        if (-1 != (index = path.indexOf(servicePrefix))) {
            int serviceStart = index + servicePrefix.length();
            if (path.length() > serviceStart + 1) {
                String service = path.substring(serviceStart);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                if (path.startsWith("jms:/")) {
                    boolean slashPresent = baseUri.endsWith("/") || service.startsWith("/");
                    service = baseUri + "/" + service;
                }
                return service;
            }
        }
        return null;
    }

    private static void declarePartsElements(Definition wsdlDefinition, QName wsdlServiceName, String axisServiceName, String portName) {
        List wsldOps = wsdlDefinition.getService(wsdlServiceName).getPort(portName).getBinding().getPortType().getOperations();
        for (Object wsldOp : wsldOps) {
            Part part;
            Operation wsdlOp = (Operation)wsldOp;
            Collection parts = wsdlOp.getInput().getMessage().getParts().values();
            if (parts.size() != 1 || (part = (Part)parts.iterator().next()).getElementName() == null) continue;
            ODEAxisOperationDispatcher.addElmtToOpMapping(axisServiceName, wsdlOp.getName(), part.getElementName().getLocalPart());
        }
    }

    public static String deriveBaseServiceUri(ProcessConf pconf) {
        if (pconf != null) {
            StringBuffer baseServiceUri = new StringBuffer();
            String bundleName = pconf.getPackage();
            if (bundleName != null) {
                baseServiceUri.append(bundleName).append("/");
                if (pconf.getBpelDocument() != null) {
                    String processName;
                    String bpelDocumentName = pconf.getBpelDocument();
                    if (bpelDocumentName.indexOf(".") > 0) {
                        bpelDocumentName = bpelDocumentName.substring(0, bpelDocumentName.indexOf("."));
                    }
                    baseServiceUri.append(bpelDocumentName).append("/");
                    String string = processName = pconf.getType() != null ? pconf.getType().getLocalPart() : null;
                    if (processName != null) {
                        baseServiceUri.append(processName);
                        return baseServiceUri.toString();
                    }
                }
            }
        }
        return null;
    }

    public static class WSDL11ToAxisPatchedBuilder
    extends WSDL11ToAxisServiceBuilder {
        private static Map<String, WeakReference<XmlSchema>> cached = new HashMap<String, WeakReference<XmlSchema>>();

        public WSDL11ToAxisPatchedBuilder(InputStream in, QName serviceName, String portName) {
            super(in, serviceName, portName);
        }

        public WSDL11ToAxisPatchedBuilder(Definition def, QName serviceName, String portName) {
            super(def, serviceName, portName);
        }

        public WSDL11ToAxisPatchedBuilder(Definition def, QName serviceName, String portName, boolean isAllPorts) {
            super(def, serviceName, portName, isAllPorts);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream in, AxisService service) {
            super(in, service);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected XmlSchema getXMLSchema(Element element, String baseUri) {
            Map<String, WeakReference<XmlSchema>> map = cached;
            synchronized (map) {
                XmlSchema s;
                String digest = baseUri;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getXMLSchema identity: " + System.identityHashCode(element) + " baseURI: " + baseUri + " elementBaseURI: " + element.getBaseURI() + " documentBaseURI:" + element.getOwnerDocument().getBaseURI() + " documentURI: " + element.getOwnerDocument().getDocumentURI() + " digest: " + digest));
                }
                if (cached.containsKey(digest) && (s = (XmlSchema)cached.get(digest).get()) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cache hit for schema guid " + digest));
                    }
                    return s;
                }
                XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
                if (baseUri != null) {
                    schemaCollection.setBaseUri(baseUri);
                }
                XmlSchema schema = schemaCollection.read(element, baseUri);
                cached.put(digest, new WeakReference<XmlSchema>(schema));
                return schema;
            }
        }
    }
}

