/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.deploy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ODEServer;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.engine.cron.SystemSchedulesConfig;
import org.apache.ode.utils.WatchDog;

public class DeploymentPoller {
    private static Log __log = LogFactory.getLog(DeploymentPoller.class);
    private static final long POLL_TIME = 3000L;
    private File _deployDir;
    private PollingThread _poller;
    protected ODEServer _odeServer;
    private boolean _onHold = false;
    private SystemSchedulesConfig _systemSchedulesConf;
    private Map<String, WatchDog> dDWatchDogsByPath = new HashMap<String, WatchDog>();
    private WatchDog _systemCronConfigWatchDog;
    private static final FileFilter _fileFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return new File(path, "deploy.xml").exists();
        }
    };
    private static final FileFilter _deployedFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.isFile() && path.getName().endsWith(".deployed");
        }
    };

    public DeploymentPoller(File deployDir, ODEServer odeServer) {
        boolean isDeployDirCreated;
        this._odeServer = odeServer;
        this._deployDir = deployDir;
        if (!this._deployDir.exists() && !(isDeployDirCreated = this._deployDir.mkdir())) {
            __log.error((Object)("Error while creating deploy directory " + deployDir.getName()));
        }
        this._systemSchedulesConf = this.createSystemSchedulesConfig(odeServer.getConfigRoot());
        this._systemCronConfigWatchDog = this.createSystemCronConfigWatchDog(odeServer.getBpelServer().getContexts().cronScheduler);
    }

    public void start() {
        this._poller = new PollingThread();
        this._poller.start();
        __log.info((Object)"Poller started.");
    }

    public void stop() {
        this._poller.kill();
        this._poller = null;
        __log.info((Object)"Poller stopped.");
    }

    protected boolean isDeploymentFromODEFileSystemAllowed() {
        return true;
    }

    private void check() {
        File[] deployed;
        File[] files = this._deployDir.listFiles(_fileFilter);
        if (this.isDeploymentFromODEFileSystemAllowed() && files != null) {
            for (File file : files) {
                block12: {
                    File deployXml = new File(file, "deploy.xml");
                    File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
                    if (!deployXml.exists()) {
                        __log.debug((Object)("Not deploying " + file + " (missing deploy.xml)"));
                    }
                    WatchDog ddWatchDog = this.ensureDeployXmlWatchDog(file, deployXml);
                    if (deployedMarker.exists()) {
                        this.checkDeployXmlWatchDog(ddWatchDog);
                        continue;
                    }
                    try {
                        boolean isCreated = deployedMarker.createNewFile();
                        if (isCreated) break block12;
                        __log.error((Object)("Error while creating  file " + file.getName() + ".deployed ,deployment could be inconsistent"));
                    }
                    catch (IOException e1) {
                        __log.error((Object)("Error creating deployed marker file, " + file + " will not be deployed"));
                        continue;
                    }
                }
                try {
                    this._odeServer.getProcessStore().undeploy(file);
                }
                catch (Exception ex) {
                    __log.error((Object)("Error undeploying " + file.getName()));
                }
                try {
                    Collection deployed2 = this._odeServer.getProcessStore().deploy(file);
                    __log.info((Object)("Deployment of artifact " + file.getName() + " successful: " + deployed2));
                }
                catch (Exception e) {
                    __log.error((Object)("Deployment of " + file.getName() + " failed, aborting for now."), (Throwable)e);
                }
            }
        }
        for (File file : deployed = this._deployDir.listFiles(_deployedFilter)) {
            String pkg = file.getName().substring(0, file.getName().length() - ".deployed".length());
            File deployDir = new File(this._deployDir, pkg);
            if (deployDir.exists()) continue;
            Collection undeployed = this._odeServer.getProcessStore().undeploy(deployDir);
            boolean isDeleted = file.delete();
            if (!isDeleted) {
                __log.error((Object)("Error while deleting file " + file.getName() + ".deployed , please check if file is locked or if it really exist"));
            }
            this.disposeDeployXmlWatchDog(deployDir);
            if (undeployed.size() <= 0) continue;
            __log.info((Object)("Successfully undeployed " + pkg));
        }
        this.checkSystemCronConfigWatchDog(this._systemCronConfigWatchDog);
    }

    protected WatchDog ensureDeployXmlWatchDog(File deployFolder, File deployXml) {
        WatchDog ddWatchDog = this.dDWatchDogsByPath.get(deployXml.getAbsolutePath());
        if (ddWatchDog == null) {
            ddWatchDog = WatchDog.watchFile((File)deployXml, (WatchDog.Observer)new DDWatchDogObserver(deployFolder.getName()));
            this.dDWatchDogsByPath.put(deployXml.getAbsolutePath(), ddWatchDog);
        }
        return ddWatchDog;
    }

    protected void checkDeployXmlWatchDog(WatchDog ddWatchDog) {
        ddWatchDog.check();
    }

    protected void disposeDeployXmlWatchDog(File deployDir) {
        this.dDWatchDogsByPath.remove(new File(deployDir, "deploy.xml").getAbsolutePath());
    }

    protected SystemSchedulesConfig createSystemSchedulesConfig(File configRoot) {
        return new SystemSchedulesConfig(configRoot);
    }

    protected WatchDog createSystemCronConfigWatchDog(final CronScheduler cronScheduler) {
        return WatchDog.watchFile((File)this._systemSchedulesConf.getSchedulesFile(), (WatchDog.Observer)new WatchDog.DefaultObserver(){

            public void init() {
                cronScheduler.refreshSystemCronJobs(DeploymentPoller.this._systemSchedulesConf);
            }
        });
    }

    protected void checkSystemCronConfigWatchDog(WatchDog ddWatchDog) {
        ddWatchDog.check();
    }

    public void hold() {
        this._onHold = true;
    }

    public void release() {
        this._onHold = false;
    }

    public void markAsDeployed(File file) {
        File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
        try {
            boolean isCreated = deployedMarker.createNewFile();
            if (!isCreated) {
                __log.error((Object)("Error while creating  file " + file.getName() + ".deployed ,deployment could be inconsistent"));
            }
        }
        catch (IOException e) {
            __log.error((Object)("Couldn't create marker file for " + file.getName()));
        }
    }

    public void markAsUndeployed(File file) {
        File deployedMarker = new File(this._deployDir, file.getName() + ".deployed");
        boolean isDeleted = deployedMarker.delete();
        if (!isDeleted) {
            __log.error((Object)("Error while deleting file " + file.getName() + ".deployed , please check if file is locked or if it really exist"));
        }
    }

    protected class DDWatchDogObserver
    extends WatchDog.DefaultObserver {
        private String deploymentPakage;

        public DDWatchDogObserver(String deploymentPakage) {
            this.deploymentPakage = deploymentPakage;
        }

        public void init() {
            DeploymentPoller.this._odeServer.getProcessStore().refreshSchedules(this.deploymentPakage);
        }
    }

    private class PollingThread
    extends Thread {
        private boolean _active = true;

        public PollingThread() {
            this.setName("DeploymentPoller");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            PollingThread pollingThread = this;
            synchronized (pollingThread) {
                this._active = false;
                this.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException ie) {
                __log.fatal((Object)"Thread unexpectedly interrupted.", (Throwable)ie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this._active) {
                    if (!DeploymentPoller.this._onHold) {
                        DeploymentPoller.this.check();
                    }
                    PollingThread pollingThread = this;
                    synchronized (pollingThread) {
                        try {
                            this.wait(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            catch (Throwable t) {
                __log.fatal((Object)"Encountered an unexpected error.  Exiting poller...", t);
            }
        }
    }
}

