/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.BindingContextImpl;
import org.apache.ode.axis2.EndpointReferenceContextImpl;
import org.apache.ode.axis2.MessageExchangeContextImpl;
import org.apache.ode.axis2.Messages;
import org.apache.ode.axis2.ODEConfigProperties;
import org.apache.ode.axis2.deploy.DeploymentPoller;
import org.apache.ode.axis2.service.DeploymentWebService;
import org.apache.ode.axis2.service.ManagementService;
import org.apache.ode.axis2.util.ClusterUrlTransformer;
import org.apache.ode.bpel.connector.BpelServerConnector;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionBundleValidation;
import org.apache.ode.bpel.extension.ExtensionCorrelationFilter;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.fs.TempFileManager;

public class ODEServer {
    protected final Log __log = LogFactory.getLog(this.getClass());
    protected final Log __logTx = LogFactory.getLog((String)"org.apache.ode.tx");
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    protected File _appRoot;
    protected File _workRoot;
    protected File _configRoot;
    protected BpelServerImpl _bpelServer;
    protected ProcessStoreImpl _store;
    protected ODEConfigProperties _odeConfig;
    protected AxisConfiguration _axisConfig;
    protected TransactionManager _txMgr;
    protected BpelDAOConnectionFactory _daoCF;
    protected ExecutorService _executorService;
    protected Scheduler _scheduler;
    protected CronScheduler _cronScheduler;
    protected Database _db;
    private DeploymentPoller _poller;
    private BpelServerConnector _connector;
    private ManagementService _mgtService;
    protected ClusterUrlTransformer _clusterUrlTransformer;
    protected MultiThreadedHttpConnectionManager httpConnectionManager;
    protected IdleConnectionTimeoutThread idleConnectionTimeoutThread;

    public void init(ServletConfig config, AxisConfiguration axisConf) throws ServletException {
        this.init(config.getServletContext().getRealPath("/WEB-INF"), axisConf);
    }

    public void init(String contextPath, AxisConfiguration axisConf) throws ServletException {
        this._axisConfig = axisConf;
        String rootDir = System.getProperty("org.apache.ode.rootDir");
        this._appRoot = rootDir != null ? new File(rootDir) : new File(contextPath);
        if (!this._appRoot.isDirectory()) {
            throw new IllegalArgumentException(this._appRoot + " does not exist or is not a directory");
        }
        TempFileManager.setWorkingDirectory((File)this._appRoot);
        this.__log.debug((Object)"Loading properties");
        String confDir = System.getProperty("org.apache.ode.configDir");
        File file = this._configRoot = confDir == null ? new File(this._appRoot, "conf") : new File(confDir);
        if (!this._configRoot.isDirectory()) {
            throw new IllegalArgumentException(this._configRoot + " does not exist or is not a directory");
        }
        this._odeConfig = new ODEConfigProperties(this._configRoot);
        try {
            this._odeConfig.load();
        }
        catch (FileNotFoundException fnf) {
            String errmsg = __msgs.msgOdeInstallErrorCfgNotFound(this._odeConfig.getFile());
            this.__log.warn((Object)errmsg);
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeInstallErrorCfgReadError(this._odeConfig.getFile());
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
        String wdir = this._odeConfig.getWorkingDir();
        this._workRoot = wdir == null ? this._appRoot : new File(wdir.trim());
        if (!this._workRoot.isDirectory()) {
            throw new IllegalArgumentException(this._workRoot + " does not exist or is not a directory");
        }
        this.__log.debug((Object)"Initializing transaction manager");
        this.initTxMgr();
        this.__log.debug((Object)"Creating data source.");
        this.initDataSource();
        this.__log.debug((Object)"Starting DAO.");
        this.initDAO();
        EndpointReferenceContextImpl eprContext = new EndpointReferenceContextImpl(this);
        this.__log.debug((Object)"Initializing BPEL process store.");
        this.initProcessStore(eprContext);
        this.__log.debug((Object)"Initializing BPEL server.");
        this.initBpelServer(eprContext);
        this.__log.debug((Object)"Initializing HTTP connection manager");
        this.initHttpConnectionManager();
        this.registerEventListeners();
        this.registerMexInterceptors();
        this.registerExtensionActivityBundles();
        this.registerExtensionCorrelationFilters();
        this.registerExternalVariableModules();
        this._store.loadAll();
        try {
            this._bpelServer.start();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeBpelServerStartFailure();
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
        this._poller = this.getDeploymentPollerExt();
        if (this._poller == null) {
            this._poller = new DeploymentPoller(this._store.getDeployDir(), this);
        }
        this._mgtService = new ManagementService();
        this._mgtService.enableService(this._axisConfig, (BpelServer)this._bpelServer, (ProcessStore)this._store, this._appRoot.getAbsolutePath());
        try {
            this.__log.debug((Object)"Initializing Deployment Web Service");
            new DeploymentWebService().enableService(this._axisConfig, (ProcessStore)this._store, this._poller, this._appRoot.getAbsolutePath(), this._workRoot.getAbsolutePath());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.__log.debug((Object)"Starting scheduler");
        this._scheduler.start();
        this.__log.debug((Object)"Initializing JCA adapter.");
        this.initConnector();
        this._poller.start();
        this.__log.info((Object)__msgs.msgPollingStarted(this._store.getDeployDir().getAbsolutePath()));
        this.__log.info((Object)__msgs.msgOdeStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentPoller getDeploymentPollerExt() {
        DeploymentPoller poller;
        block13: {
            poller = null;
            InputStream is = null;
            try {
                is = ODEServer.class.getResourceAsStream("/deploy-ext.properties");
                if (is != null) {
                    this.__log.info((Object)"A deploy-ext.properties found; will use the provided class if applicable.");
                    try {
                        Properties props = new Properties();
                        props.load(is);
                        String deploymentPollerClass = props.getProperty("deploymentPoller.class");
                        if (deploymentPollerClass == null) {
                            this.__log.warn((Object)"deploy-ext.properties found in the class path; however, the file does not have 'deploymentPoller.class' as one of the properties!!");
                            break block13;
                        }
                        Class<?> pollerClass = Class.forName(deploymentPollerClass);
                        poller = (DeploymentPoller)pollerClass.getConstructor(File.class, ODEServer.class).newInstance(this._store.getDeployDir(), this);
                        this.__log.info((Object)("A custom deployment poller: " + deploymentPollerClass + " has been plugged in."));
                    }
                    catch (Exception e) {
                        this.__log.warn((Object)"Deployment poller extension class is not loadable, falling back to the default DeploymentPoller.", (Throwable)e);
                    }
                    break block13;
                }
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)"No deploy-ext.properties found.");
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return poller;
    }

    private void initDataSource() throws ServletException {
        this._db = new Database((OdeConfigProperties)this._odeConfig);
        this._db.setTransactionManager(this._txMgr);
        this._db.setWorkRoot(this._workRoot);
        try {
            this._db.start();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbConfigError();
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws AxisFault {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this._poller != null) {
                try {
                    this.__log.debug((Object)"shutting down poller");
                    this._poller.stop();
                    this._poller = null;
                }
                catch (Throwable t) {
                    this.__log.debug((Object)"Error stopping poller.", t);
                }
            }
            if (this._bpelServer != null) {
                try {
                    this.__log.debug((Object)"shutting down ODE server.");
                    this._bpelServer.shutdown();
                    this._bpelServer = null;
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"Error stopping services.", ex);
                }
            }
            if (this._cronScheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down cron scheduler.");
                    this._cronScheduler.shutdown();
                    this._cronScheduler = null;
                }
                catch (Exception ex) {
                    this.__log.debug((Object)"Cron scheduler couldn't be shutdown.", (Throwable)ex);
                }
            }
            if (this._scheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down scheduler.");
                    this._scheduler.shutdown();
                    this._scheduler = null;
                }
                catch (Exception ex) {
                    this.__log.debug((Object)"Scheduler couldn't be shutdown.", (Throwable)ex);
                }
            }
            if (this._store != null) {
                try {
                    this._store.shutdown();
                    this._store = null;
                }
                catch (Throwable t) {
                    this.__log.debug((Object)"Store could not be shutdown.", t);
                }
            }
            if (this._daoCF != null) {
                try {
                    this._daoCF.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DOA shutdown failed.", ex);
                }
                finally {
                    this._daoCF = null;
                }
            }
            if (this._db != null) {
                try {
                    this._db.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DB shutdown failed.", ex);
                }
                finally {
                    this._db = null;
                }
            }
            if (this._txMgr != null) {
                this.__log.debug((Object)"shutting down transaction manager.");
                this._txMgr = null;
            }
            if (this._connector != null) {
                try {
                    this.__log.debug((Object)"shutdown BpelConnector");
                    this._connector.shutdown();
                }
                catch (Throwable t) {
                    this.__log.error((Object)"Unable to cleanup temp files.", t);
                }
            }
            if (this.httpConnectionManager != null) {
                this.__log.debug((Object)"shutting down HTTP connection manager.");
                try {
                    this.httpConnectionManager.shutdown();
                }
                catch (Throwable t) {
                    this.__log.error((Object)"Unable to shut down HTTP connection manager.", t);
                }
            }
            if (this.idleConnectionTimeoutThread != null) {
                this.__log.debug((Object)"shutting down Idle Connection Timeout Thread.");
                try {
                    this.idleConnectionTimeoutThread.shutdown();
                }
                catch (Throwable t) {
                    this.__log.error((Object)"Unable to shut down Idle Connection Timeout Thread.", t);
                }
            }
            try {
                this.__log.debug((Object)"cleaning up temporary files.");
                TempFileManager.cleanup();
            }
            catch (Throwable t) {
                this.__log.error((Object)"Unable to cleanup temp files.", t);
            }
            this._executorService.shutdownNow();
            this.__log.info((Object)__msgs.msgOdeShutdownCompleted());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void initTxMgr() throws ServletException {
        String txFactoryName = this._odeConfig.getTxFactoryClass();
        this.__log.debug((Object)("Initializing transaction manager using " + txFactoryName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
            if (this.__logTx.isDebugEnabled() && System.getProperty("ode.debug.tx") != null) {
                this._txMgr = new DebugTxMgr(this._txMgr);
            }
        }
        catch (Exception e) {
            this.__log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new ServletException("Couldn't initialize a transaction manager with factory: " + txFactoryName, (Throwable)e);
        }
    }

    private void initConnector() throws ServletException {
        int port = this._odeConfig.getConnectorPort();
        if (port == 0) {
            this.__log.info((Object)"Skipping connector initialization.");
        } else {
            this._connector = new BpelServerConnector();
            this._connector.setBpelServer((BpelServer)this._bpelServer);
            this._connector.setProcessStore((ProcessStore)this._store);
            this._connector.setPort(this._odeConfig.getConnectorPort());
            this._connector.setId("jcaServer");
            try {
                this._connector.start();
            }
            catch (Exception e) {
                this.__log.error((Object)"Failed to initialize JCA connector.", (Throwable)e);
            }
        }
    }

    protected void initDAO() throws ServletException {
        this.__log.info((Object)__msgs.msgOdeUsingDAOImpl(this._odeConfig.getDAOConnectionFactory()));
        try {
            this._daoCF = this._db.createDaoCF();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgDAOInstantiationFailed(this._odeConfig.getDAOConnectionFactory());
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new ServletException(errmsg, (Throwable)ex);
        }
    }

    protected void initProcessStore(EndpointReferenceContext eprContext) {
        this._store = this.createProcessStore(eprContext, this._db.getDataSource());
        this._store.registerListener((ProcessStoreListener)new ProcessStoreListenerImpl());
        this._store.setDeployDir(this._odeConfig.getDeployDir() != null ? new File(this._odeConfig.getDeployDir()) : new File(this._workRoot, "processes"));
        this._store.setConfigDir(this._configRoot);
    }

    protected ProcessStoreImpl createProcessStore(EndpointReferenceContext eprContext, DataSource ds) {
        return new ProcessStoreImpl(eprContext, ds, this._odeConfig.getDAOConnectionFactory(), (OdeConfigProperties)this._odeConfig, false);
    }

    protected Scheduler createScheduler() {
        SimpleScheduler scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._db.getDataSource()), this._odeConfig.getProperties());
        scheduler.setExecutorService(this._executorService);
        scheduler.setTransactionManager(this._txMgr);
        return scheduler;
    }

    private void initBpelServer(EndpointReferenceContextImpl eprContext) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"ODE initializing");
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            int threadNumber = 0;

            @Override
            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "ODEServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        this._executorService = this._odeConfig.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(this._odeConfig.getThreadPoolMaxSize(), threadFactory);
        ArrayList<String> targets = new ArrayList<String>();
        Collections.addAll(targets, this._odeConfig.getProperty("cluster.localRoute.targets", "").split(","));
        this._clusterUrlTransformer = new ClusterUrlTransformer(targets, this._odeConfig.getProperty("cluster.localRoute.base", "http://localhost:8080/ode/processes/"));
        this._bpelServer = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._bpelServer);
        BpelServerImpl.PolledRunnableProcessor polledRunnableProcessor = new BpelServerImpl.PolledRunnableProcessor();
        polledRunnableProcessor.setPolledRunnableExecutorService(this._executorService);
        polledRunnableProcessor.setContexts(this._bpelServer.getContexts());
        this._scheduler.setPolledRunnableProcesser((Scheduler.JobProcessor)polledRunnableProcessor);
        this._cronScheduler = new CronScheduler();
        this._cronScheduler.setScheduledTaskExec(this._executorService);
        this._cronScheduler.setContexts(this._bpelServer.getContexts());
        this._bpelServer.setCronScheduler(this._cronScheduler);
        this._bpelServer.setDaoConnectionFactory(this._daoCF);
        this._bpelServer.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this._scheduler, this._odeConfig.getInMemMexTtl()));
        this._bpelServer.setEndpointReferenceContext((EndpointReferenceContext)eprContext);
        this._bpelServer.setMessageExchangeContext((MessageExchangeContext)new MessageExchangeContextImpl(this));
        this._bpelServer.setBindingContext((BindingContext)new BindingContextImpl(this));
        this._bpelServer.setScheduler(this._scheduler);
        if (this._odeConfig.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            dehy.setProcessMaxAge(this._odeConfig.getDehydrationMaximumAge());
            dehy.setProcessMaxCount(this._odeConfig.getDehydrationMaximumCount());
            this._bpelServer.setDehydrationPolicy((DehydrationPolicy)dehy);
        }
        this._bpelServer.setMigrationTransactionTimeout(this._odeConfig.getMigrationTransactionTimeout());
        this._bpelServer.setConfigProperties(this._odeConfig.getProperties());
        this._bpelServer.init();
        this._bpelServer.setInstanceThrottledMaximumCount(this._odeConfig.getInstanceThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumCount(this._odeConfig.getProcessThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumSize(this._odeConfig.getProcessThrottledMaximumSize());
        this._bpelServer.setHydrationLazy(this._odeConfig.isHydrationLazy());
        this._bpelServer.setHydrationLazyMinimumSize(this._odeConfig.getHydrationLazyMinimumSize());
    }

    private void initHttpConnectionManager() throws ServletException {
        this.httpConnectionManager = new MultiThreadedHttpConnectionManager();
        int max_per_host = Integer.parseInt(this._odeConfig.getProperty("http.connection-manager.max-per-host", "" + this._odeConfig.getPoolMaxSize()));
        int max_total = Integer.parseInt(this._odeConfig.getProperty("http.connection-manager.max-total", "" + this._odeConfig.getPoolMaxSize()));
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("http.connection-manager.max-per-host=" + max_per_host));
            this.__log.debug((Object)("http.connection-manager.max-total=" + max_total));
        }
        if (max_per_host < 1 || max_total < 1) {
            String errmsg = "http.connection-manager.max-per-host and http.connection-manager.max-total must be positive integers!";
            this.__log.error((Object)errmsg);
            throw new ServletException(errmsg);
        }
        this.httpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(max_per_host);
        this.httpConnectionManager.getParams().setMaxTotalConnections(max_total);
        this.idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
        this.idleConnectionTimeoutThread.setName("Http_Idle_Connection_Timeout_Thread");
        long idleConnectionTimeout = Long.parseLong(this._odeConfig.getProperty("http.idle.connection.timeout", "30000"));
        long idleConnectionCheckInterval = Long.parseLong(this._odeConfig.getProperty("http.idle.connection.check.interval", "30000"));
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("http.idle.connection.timeout=" + idleConnectionTimeout));
            this.__log.debug((Object)("http.idle.connection.check.interval=" + idleConnectionCheckInterval));
        }
        this.idleConnectionTimeoutThread.setConnectionTimeout(idleConnectionTimeout);
        this.idleConnectionTimeoutThread.setTimeoutInterval(idleConnectionCheckInterval);
        this.idleConnectionTimeoutThread.addConnectionManager((HttpConnectionManager)this.httpConnectionManager);
        this.idleConnectionTimeoutThread.start();
    }

    public ProcessStoreImpl getProcessStore() {
        return this._store;
    }

    public BpelServerImpl getBpelServer() {
        return this._bpelServer;
    }

    public InstanceManagement getInstanceManagement() {
        return this._mgtService.getInstanceMgmt();
    }

    public ProcessManagement getProcessManagement() {
        return this._mgtService.getProcessMgmt();
    }

    public File getAppRoot() {
        return this._appRoot;
    }

    public File getConfigRoot() {
        return this._configRoot;
    }

    private void registerEventListeners() {
        String listenersStr = this._odeConfig.getEventListeners();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String listenerCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    this.__log.info((Object)__msgs.msgBpelEventListenerRegistered(listenerCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String listenersStr = this._odeConfig.getMessageExchangeInterceptors();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String interceptorCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    this.__log.info((Object)__msgs.msgMessageExchangeInterceptorRegistered(interceptorCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcext = new JdbcExternalVariableModule();
        jdbcext.registerDataSource("ode", this._db.getDataSource());
        this._bpelServer.registerExternalVariableEngine((ExternalVariableModule)jdbcext);
    }

    private void handleEvent(ProcessStoreEvent pse) {
        this.__log.debug((Object)("Process store event: " + pse));
        ProcessConf pconf = this._store.getProcessConfiguration(pse.pid);
        switch (pse.type) {
            case DEPLOYED: {
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case ACTIVATED: {
                this._bpelServer.unregister(pse.pid);
                if (pconf != null) {
                    this._bpelServer.register(pconf);
                    break;
                }
                this.__log.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                break;
            }
            case RETIRED: {
                boolean instantiated = this._bpelServer.hasActiveInstances(pse.pid);
                this._bpelServer.unregister(pse.pid);
                if (instantiated) {
                    if (pconf != null) {
                        this._bpelServer.register(pconf);
                        break;
                    }
                    this.__log.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                    break;
                }
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case DISABLED: 
            case UNDEPLOYED: {
                this._bpelServer.unregister(pse.pid);
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            default: {
                this.__log.debug((Object)("Ignoring store event: " + pse));
            }
        }
        if (pconf != null) {
            if (pse.type == ProcessStoreEvent.Type.UNDEPLOYED) {
                this.__log.debug((Object)("Cancelling all cron scheduled jobs on store event: " + pse));
                this._bpelServer.getContexts().cronScheduler.cancelProcessCronJobs(pse.pid, true);
            }
            this.__log.debug((Object)("(Re)scheduling cron scheduled jobs on store event: " + pse));
            if (pse.type != ProcessStoreEvent.Type.UNDEPLOYED) {
                this._bpelServer.getContexts().cronScheduler.scheduleProcessCronJobs(pse.pid, pconf);
            }
        }
    }

    private void registerExtensionActivityBundles() {
        String extensionsRTStr = this._odeConfig.getExtensionActivityBundlesRT();
        String extensionsValStr = this._odeConfig.getExtensionActivityBundlesValidation();
        if (extensionsRTStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionsRTStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String bundleCN = tokenizer.nextToken();
                try {
                    ExtensionBundleRuntime bundleRT = (ExtensionBundleRuntime)Class.forName(bundleCN).newInstance();
                    this._bpelServer.registerExtensionBundle(bundleRT);
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the extension bundle runtime " + bundleCN + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
        if (extensionsValStr != null) {
            HashMap validators = new HashMap();
            StringTokenizer tokenizer = new StringTokenizer(extensionsValStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String bundleCN = tokenizer.nextToken();
                try {
                    ExtensionBundleValidation bundleVal = (ExtensionBundleValidation)Class.forName(bundleCN).newInstance();
                    validators.putAll(bundleVal.getExtensionValidators());
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the extension bundle validator " + bundleCN + ", the class couldn't be " + "loaded properly."));
                }
            }
            this._store.setExtensionValidators(validators);
        }
    }

    private void registerExtensionCorrelationFilters() {
        String extensionFilterStr = this._odeConfig.getExtensionCorrelationFilters();
        if (extensionFilterStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionFilterStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String filterCN = tokenizer.nextToken();
                try {
                    ExtensionCorrelationFilter filterRT = (ExtensionCorrelationFilter)Class.forName(filterCN).newInstance();
                    this._bpelServer.registerExtensionCorrelationFilter(filterRT);
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the extension correlation filter " + filterCN + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
    }

    private class DebugTx
    implements Transaction {
        private Transaction _tx;

        public DebugTx(Transaction tx) {
            this._tx = tx;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx commit");
            this._tx.commit();
        }

        public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
            return this._tx.delistResource(xaResource, i);
        }

        public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
            return this._tx.enlistResource(xaResource);
        }

        public int getStatus() throws SystemException {
            return this._tx.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            ODEServer.this.__logTx.debug((Object)("Synchronization registration on " + synchronization.getClass().getName()));
            this._tx.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx rollback");
            this._tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx set rollback");
            this._tx.setRollbackOnly();
        }
    }

    private class DebugTxMgr
    implements TransactionManager {
        private TransactionManager _tm;

        public DebugTxMgr(TransactionManager tm) {
            this._tm = tm;
        }

        public void begin() throws NotSupportedException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm begin");
            this._tm.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm commit");
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                ODEServer.this.__logTx.debug((Object)traceElement.toString());
            }
            this._tm.commit();
        }

        public int getStatus() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm status");
            return this._tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this._tm.getTransaction();
            ODEServer.this.__logTx.debug((Object)("Txm get tx " + tx));
            return tx == null ? null : new DebugTx(tx);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm resume");
            this._tm.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm rollback");
            this._tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm set rollback");
            this._tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            ODEServer.this.__logTx.debug((Object)("Txm set tiemout " + i));
            this._tm.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm suspend");
            return this._tm.suspend();
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent event) {
            ODEServer.this.handleEvent(event);
        }
    }
}

