/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.compiler.bom.ExtensibilityQNames;
import org.w3c.dom.Element;

public class Variable
extends BpelObject {
    public Variable(Element el) {
        super(el);
    }

    public String getName() {
        return this.getAttribute("name", null);
    }

    public QName getTypeName() {
        String typename = null;
        switch (this.getKind()) {
            case MESSAGE: {
                typename = this.getAttribute("messageType", null);
                break;
            }
            case SCHEMA: {
                typename = this.getAttribute("type", null);
                break;
            }
            case ELEMENT: {
                typename = this.getAttribute("element", null);
            }
        }
        if (typename == null) {
            return null;
        }
        return this.getNamespaceContext().derefQName(typename);
    }

    public Kind getKind() {
        if (this.getAttribute("messageType", null) != null) {
            return Kind.MESSAGE;
        }
        if (this.getAttribute("type", null) != null) {
            return Kind.SCHEMA;
        }
        if (this.getAttribute("element", null) != null) {
            return Kind.ELEMENT;
        }
        return null;
    }

    public String getExternalId() {
        return this.getAttribute(ExtensibilityQNames.EXTVAR_ATTR, null);
    }

    public boolean isExternal() {
        return null != this.getExternalId();
    }

    public String getRelated() {
        return this.getAttribute(ExtensibilityQNames.EXTVAR_RELATED, null);
    }

    public static enum Kind {
        SCHEMA,
        ELEMENT,
        MESSAGE;

    }
}

