/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.net.InetAddress;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomProcessProperties {
    private static final Log __log = LogFactory.getLog(CustomProcessProperties.class);

    public Node getProperty(QName propertyName) {
        String name = propertyName.getLocalPart();
        try {
            if (name.equals("ode.localhost.name")) {
                return CustomProcessProperties.stringToNode(InetAddress.getLocalHost().getHostName());
            }
            if (name.equals("ode.localhost.address")) {
                return CustomProcessProperties.stringToNode(InetAddress.getLocalHost().getHostAddress());
            }
            return null;
        }
        catch (Exception e) {
            __log.warn((Object)("Can't evaluate property " + propertyName), (Throwable)e);
            return null;
        }
    }

    public static Node stringToNode(String s) {
        Document d = DOMUtils.newDocument();
        Element e = d.createElement("value");
        e.setTextContent(s);
        d.appendChild(e);
        return d.getDocumentElement();
    }
}

