/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NStateLatch {
    static final Log __log = LogFactory.getLog(NStateLatch.class);
    private int _state = -1;
    private int _depth = 0;
    protected Runnable[] _transitions;
    private Lock _lock;
    private Condition _depth0;
    private boolean _transitioning = false;

    public NStateLatch(Runnable[] transitions) {
        this._transitions = transitions;
        this._lock = new ReentrantLock();
        this._depth0 = this._lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void latch(int state) {
        block10: {
            if (state >= this._transitions.length || state < 0) {
                throw new IllegalArgumentException("Invalid state.");
            }
            this._lock.lock();
            try {
                if (this._transitioning) {
                    throw new IllegalStateException("Manipulating latch from transition. ");
                }
                if (this._state == state) break block10;
                while (this._depth != 0) {
                    this._depth0.awaitUninterruptibly();
                }
                if (this._state == state) break block10;
                if (this._transitions[state] != null) {
                    try {
                        this._transitioning = true;
                        this._transitions[state].run();
                    }
                    finally {
                        this._transitioning = false;
                    }
                }
                this._state = state;
            }
            finally {
                ++this._depth;
                this._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int state) {
        this._lock.lock();
        try {
            if (this._transitioning) {
                throw new IllegalStateException("Manipulating latch from transition. ");
            }
            if (this._state != state) {
                Exception throwable = new Exception();
                String stackTraceString = NStateLatch.getStackTrace(throwable);
                __log.error((Object)("Latch error, was releasing for state " + state + " but actually in " + this._state + "\n" + stackTraceString));
            }
            if (this._depth <= 0) {
                throw new IllegalStateException("Too many release() calls.");
            }
            --this._depth;
            if (this._depth == 0) {
                this._depth0.signal();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public int getDepth(int state) {
        return this._state == state ? this._depth : 0;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

